*** Settings ***
Library      OperatingSystem
Test Setup   Directory Should Exist   D:${/}zzz

*** Variables ***
${OBLIBENY_ADR}             D:${/}zzz
${OCEKAVANY_VYSLEDEK}       ${3}
 
*** Test Cases ***
TC.06.01
# prime pouziti funkci z Library Robot Framework
  ${pocet} =   Count Files In Directory   D:${/}zzz
  Should Be Equal As Integers   ${pocet}   3
  
TC.06.02
  [Documentation]   dve vlastni klicova slova vzdy s jednim prikazem
  ${hodnota} =   Pocet souboru v adresari   ${OBLIBENY_ADR}
  Se ma rovnat   ${hodnota}   ${OCEKAVANY_VYSLEDEK}
  
TC.06.03
  [Documentation]   jedno vlastni klicove slovo s vice prikazy
#  Pocet souboru v adresari se rovna   ${OBLIBENY_ADR}   ${OCEKAVANY_VYSLEDEK}
  Pocet souboru v adresari se rovna   ${OBLIBENY_ADR}  3

TC.06.04
  [Documentation]   jedno vlastni klicove slovo s vice prikazy a argumenty v textu
  Primo Pocet souboru v adresari ${OBLIBENY_ADR} se rovna ${OCEKAVANY_VYSLEDEK}


*** Keywords ***
Pocet souboru v adresari
  [Arguments]   ${adresar}
  ${n} =   Count Files In Directory   ${adresar}
  RETURN   ${n}

Se ma rovnat
  [Arguments]   ${hodnota}   ${expected}
  Should Be Equal As Integers   ${hodnota}   ${expected}

Pocet souboru v adresari se rovna
  [Arguments]   ${adresar}   ${expected}=${OCEKAVANY_VYSLEDEK}
  ${n} =   Pocet souboru v adresari    ${adresar}
  Se ma rovnat   ${n}   ${expected}

Primo Pocet souboru v adresari ${adresar} se rovna ${expected}
  ${n} =   Pocet souboru v adresari    ${adresar}
  Se ma rovnat   ${n}   ${expected}