*** Settings ***
Documentation  Ukázka dokumentace celého souboru
...            dalsi radka
Library        OperatingSystem
Resource       ../resources/klicovaSlova.resource
Test Setup     Directory Should Exist   ${OBLIBENY_ADR}
Force Tags     vsechno

*** Variables ***
${OBLIBENY_ADR}             D:${/}zzz
${OCEKAVANY_VYSLEDEK}       ${4}

*** Test Cases ***
TC.07.01
   [Documentation]   počet souborů v adresáři;
   ...               použití klíčových slov jen z BuiltIn
   [Tags]   jeden
   ${pocet} =   Count Files In Directory
   ...          ${OBLIBENY_ADR}   # komentar
   Should Be Equal As Integers   ${pocet}   ${OCEKAVANY_VYSLEDEK}

TC.07.02
   [Documentation]   počet souborů v adresáři; použití vlastních klíčových slov
   [Tags]   dva
   ${hodnota} =   pocet souboru v adresari  ${OBLIBENY_ADR}
   se ma rovnat   ${hodnota}   ${OCEKAVANY_VYSLEDEK}

TC.07.03
   [Documentation]   počet souborů v adresáři
   [Tags]   jeden   dva
   [Setup]    Log To Console   individualni Test Setup
   pocet souboru v adresari se rovna   ${OBLIBENY_ADR}   ${OCEKAVANY_VYSLEDEK}

Pocet souboru v adresari
   [Documentation]   počet souborů v adresáři; použití klíčových slov jen z BuiltIn
   [Tags]   jeden
   ${pocet} =   Count Files In Directory    ${OBLIBENY_ADR}
   Should Be Equal As Integers   ${pocet}   ${OCEKAVANY_VYSLEDEK}
