/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.lease;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import net.jini.core.lease.Lease;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.core.lease.LeaseMap;
import net.jini.core.lease.UnknownLeaseException;

public abstract class AbstractLease
implements Lease,
Serializable {
    private static final long serialVersionUID = -9067179156916102052L;
    protected transient long expiration;
    protected int serialFormat = 1;

    protected AbstractLease(long l) {
        this.expiration = l;
    }

    public abstract boolean canBatch(Lease var1);

    public abstract void cancel() throws UnknownLeaseException, RemoteException;

    public abstract LeaseMap createLeaseMap(long var1);

    protected abstract long doRenew(long var1) throws UnknownLeaseException, LeaseDeniedException, RemoteException;

    public long getExpiration() {
        return this.expiration;
    }

    public int getSerialFormat() {
        return this.serialFormat;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.expiration = objectInputStream.readLong();
        if (this.serialFormat == 1) {
            this.expiration += System.currentTimeMillis();
            if (this.expiration < 0L) {
                this.expiration = Long.MAX_VALUE;
            }
        }
    }

    public void renew(long l) throws UnknownLeaseException, LeaseDeniedException, RemoteException {
        this.expiration = this.doRenew(l) + System.currentTimeMillis();
        if (this.expiration < 0L) {
            this.expiration = Long.MAX_VALUE;
        }
    }

    public void setSerialFormat(int n) {
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException("invalid serial format");
        }
        this.serialFormat = n;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeLong(this.serialFormat == 2 ? this.expiration : this.expiration - System.currentTimeMillis());
    }
}

