/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.reggie;

import com.sun.jini.reggie.EntryClass;
import com.sun.jini.reggie.EntryRep;
import com.sun.jini.reggie.Item;
import com.sun.jini.reggie.ServiceType;
import com.sun.jini.reggie.Template;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;

class ClassResolver {
    private final HashMap serviceMap = new HashMap();
    private final ReferenceQueue serviceRefQueue = new ReferenceQueue();
    private final HashMap entryMap = new HashMap();
    private final ReferenceQueue entryRefQueue = new ReferenceQueue();

    public EntryClass resolve(EntryClass entryClass) {
        if (entryClass == null) {
            return null;
        }
        HashMap hashMap = this.entryMap;
        synchronized (hashMap) {
            EntryClass entryClass2;
            WeakRep weakRep;
            while ((weakRep = (WeakRep)this.entryRefQueue.poll()) != null) {
                this.entryMap.remove(weakRep.name);
            }
            weakRep = (WeakRep)this.entryMap.get(entryClass.getName());
            if (weakRep != null && (entryClass2 = (EntryClass)weakRep.get()) != null) {
                if (entryClass2.getNumFields() != entryClass.getNumFields()) {
                    throw new IncompatibleClassChangeError(String.valueOf(entryClass.getName()) + ": different number of public fields");
                }
                EntryClass entryClass3 = entryClass2;
                Object var4_7 = null;
                return entryClass3;
            }
            entryClass.canonical(this.resolve(entryClass.getSuperclass()));
            this.entryMap.put(entryClass.getName(), new WeakRep(entryClass.getName(), entryClass, this.entryRefQueue));
            EntryClass entryClass4 = entryClass;
            Object var4_8 = null;
            return entryClass4;
        }
    }

    public void resolve(Item item) {
        item.serviceType = this.resolve(item.serviceType);
        this.resolve(item.attributeSets);
    }

    public ServiceType resolve(ServiceType serviceType) {
        if (serviceType == null) {
            return null;
        }
        HashMap hashMap = this.serviceMap;
        synchronized (hashMap) {
            ServiceType serviceType2;
            WeakRep weakRep;
            while ((weakRep = (WeakRep)this.serviceRefQueue.poll()) != null) {
                this.serviceMap.remove(weakRep.name);
            }
            weakRep = (WeakRep)this.serviceMap.get(serviceType.getName());
            if (weakRep != null && (serviceType2 = (ServiceType)weakRep.get()) != null) {
                ServiceType serviceType3 = serviceType2;
                Object var4_7 = null;
                return serviceType3;
            }
            this.resolve(serviceType.getInterfaces());
            serviceType.canonical(this.resolve(serviceType.getSuperclass()));
            this.serviceMap.put(serviceType.getName(), new WeakRep(serviceType.getName(), serviceType, this.serviceRefQueue));
            ServiceType serviceType4 = serviceType;
            Object var4_8 = null;
            return serviceType4;
        }
    }

    public void resolve(Template template) {
        this.resolve(template.serviceTypes);
        this.resolve(template.attributeSetTemplates);
    }

    public void resolve(EntryRep[] entryRepArray) {
        if (entryRepArray != null) {
            int n = entryRepArray.length;
            while (--n >= 0) {
                entryRepArray[n].eclass = this.resolve(entryRepArray[n].eclass);
            }
        }
    }

    public void resolve(ServiceType[] serviceTypeArray) {
        if (serviceTypeArray != null) {
            int n = serviceTypeArray.length;
            while (--n >= 0) {
                serviceTypeArray[n] = this.resolve(serviceTypeArray[n]);
            }
        }
    }

    public void resolveWithNulls(EntryRep[] entryRepArray) {
        if (entryRepArray != null) {
            int n = entryRepArray.length;
            while (--n >= 0) {
                if (entryRepArray[n] == null) continue;
                entryRepArray[n].eclass = this.resolve(entryRepArray[n].eclass);
            }
        }
    }

    private static class WeakRep
    extends WeakReference {
        public String name;

        public WeakRep(String string, Object object, ReferenceQueue referenceQueue) {
            super(object, referenceQueue);
            this.name = string;
        }
    }
}

