/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.reggie;

import com.sun.jini.reggie.ClassMapper;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.server.RMIClassLoader;

class EntryClass
implements Serializable {
    protected String name;
    protected EntryClass superclass;
    protected int numFields;
    protected transient int numInstances;
    protected transient EntryClass replacement;
    private static final long serialVersionUID = 529192974214549379L;

    private EntryClass(EntryClass entryClass) {
        this.name = entryClass.name;
    }

    public EntryClass(Class clazz, EntryClass entryClass) {
        this.name = clazz.getName();
        this.superclass = entryClass;
        this.numFields = ClassMapper.getFields(clazz).length;
    }

    public void canonical(EntryClass entryClass) {
        this.superclass = entryClass;
        this.replacement = new EntryClass(this);
    }

    public String getName() {
        return this.name;
    }

    public int getNumFields() {
        return this.numFields;
    }

    public int getNumInstances() {
        return this.numInstances;
    }

    public EntryClass getReplacement() {
        return this.replacement;
    }

    public EntryClass getSuperclass() {
        return this.superclass;
    }

    public boolean isAssignableFrom(EntryClass entryClass) {
        EntryClass entryClass2 = entryClass;
        while (entryClass2 != null) {
            if (this == entryClass2) {
                return true;
            }
            entryClass2 = entryClass2.superclass;
        }
        return false;
    }

    public void setNumInstances(int n) {
        this.numInstances = n;
    }

    public Class toClass(String string) throws IOException, ClassNotFoundException {
        return RMIClassLoader.loadClass(string, this.name);
    }
}

