/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.reggie;

import com.sun.jini.reggie.ClassMapper;
import com.sun.jini.reggie.EntryRep;
import com.sun.jini.reggie.RegistrarProxy;
import com.sun.jini.reggie.ServiceType;
import com.sun.jini.reggie.ServiceTypeBase;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.MarshalException;
import java.rmi.MarshalledObject;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RemoteObject;
import java.util.ArrayList;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;

class Item
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -1287024425418765730L;
    public ServiceID serviceID;
    public ServiceType serviceType;
    public String codebase;
    public MarshalledObject service;
    public EntryRep[] attributeSets;

    public Item(ServiceItem serviceItem) throws RemoteException {
        Object object = serviceItem.service;
        if (object instanceof Remote) {
            try {
                object = RemoteObject.toStub((Remote)object);
            }
            catch (NoSuchObjectException noSuchObjectException) {}
        }
        this.serviceID = serviceItem.serviceID;
        ServiceTypeBase serviceTypeBase = ClassMapper.toServiceTypeBase(object.getClass());
        this.serviceType = serviceTypeBase.type;
        this.codebase = serviceTypeBase.codebase;
        try {
            this.service = new MarshalledObject<Object>(object);
        }
        catch (IOException iOException) {
            throw new MarshalException("error marshalling arguments", iOException);
        }
        this.attributeSets = EntryRep.toEntryRep(serviceItem.attributeSets, true);
    }

    public Object clone() {
        try {
            Item item = (Item)super.clone();
            EntryRep[] entryRepArray = (EntryRep[])item.attributeSets.clone();
            int n = entryRepArray.length;
            while (--n >= 0) {
                entryRepArray[n] = (EntryRep)entryRepArray[n].clone();
            }
            item.attributeSets = entryRepArray;
            return item;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public ServiceItem get() {
        Object var1_1 = null;
        try {
            var1_1 = this.service.get();
        }
        catch (Throwable throwable) {
            RegistrarProxy.handleException(throwable);
        }
        return new ServiceItem(this.serviceID, var1_1, EntryRep.toEntry(this.attributeSets));
    }

    public static ServiceItem[] toServiceItem(ArrayList arrayList) {
        ServiceItem[] serviceItemArray = null;
        if (arrayList != null) {
            serviceItemArray = new ServiceItem[arrayList.size()];
            int n = serviceItemArray.length;
            while (--n >= 0) {
                serviceItemArray[n] = ((Item)arrayList.get(n)).get();
            }
        }
        return serviceItemArray;
    }
}

