/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.reggie;

import com.sun.jini.constants.ThrowableConstants;
import com.sun.jini.lookup.entry.BasicServiceType;
import com.sun.jini.reggie.ClassResolver;
import com.sun.jini.reggie.EntryClass;
import com.sun.jini.reggie.EntryClassBase;
import com.sun.jini.reggie.EntryRep;
import com.sun.jini.reggie.EventLease;
import com.sun.jini.reggie.Item;
import com.sun.jini.reggie.Matches;
import com.sun.jini.reggie.Registrar;
import com.sun.jini.reggie.RegistrarAdminProxy;
import com.sun.jini.reggie.RegistrarEvent;
import com.sun.jini.reggie.RegistrarProxy;
import com.sun.jini.reggie.Registration;
import com.sun.jini.reggie.RenewResults;
import com.sun.jini.reggie.ServiceLease;
import com.sun.jini.reggie.ServiceType;
import com.sun.jini.reggie.ServiceTypeBase;
import com.sun.jini.reggie.Template;
import com.sun.jini.reliableLog.LogException;
import com.sun.jini.reliableLog.LogHandler;
import com.sun.jini.reliableLog.ReliableLog;
import com.sun.jini.thread.ReadersWriter;
import com.sun.jini.thread.TaskManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.MarshalledObject;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.Activatable;
import java.rmi.activation.ActivationDesc;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroup;
import java.rmi.activation.ActivationGroupID;
import java.rmi.activation.ActivationID;
import java.rmi.activation.ActivationSystem;
import java.rmi.server.RemoteObject;
import java.rmi.server.UnicastRemoteObject;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.TreeMap;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.core.event.EventRegistration;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceRegistration;
import net.jini.discovery.Constants;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.IncomingMulticastRequest;
import net.jini.discovery.IncomingUnicastRequest;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.discovery.OutgoingMulticastAnnouncement;
import net.jini.discovery.OutgoingUnicastResponse;
import net.jini.lookup.JoinManager;
import net.jini.lookup.entry.ServiceInfo;

public class RegistrarImpl
implements Registrar {
    private static final String PRODUCT = "Lookup";
    private static final String MANUFACTURER = "Sun Microsystems, Inc.";
    private static final String VENDOR = "Sun Microsystems, Inc.";
    private static final String VERSION = "1.1";
    private static final long MAX_LEASE = 31536000000000L;
    private static final long MAX_RENEW = 31536000000L;
    private static final int LOG_VERSION = 1;
    private static final EntryRep[] emptyAttrs = new EntryRep[0];
    private RegistrarProxy proxy;
    private ServiceID myServiceID;
    private ActivationID activationID;
    private LookupLocator myLocator;
    private final HashMap serviceByID = new HashMap();
    private final TreeMap serviceByTime = new TreeMap();
    private final HashMap serviceByType = new HashMap();
    private final HashMap serviceByAttr = new HashMap(23);
    private final HashMap serviceByEmptyAttr = new HashMap(11);
    private final ArrayList entryClasses = new ArrayList();
    private final HashMap eventByID = new HashMap(11);
    private final TreeMap eventByTime = new TreeMap();
    private final HashMap subEventByService = new HashMap(11);
    private final HashMap subEventByID = new HashMap(11);
    private final SecureRandom secRand = new SecureRandom();
    private final byte[] secRandBuf16 = new byte[16];
    private final byte[] secRandBuf8 = new byte[8];
    private long eventID = 0L;
    private final Random random = new Random();
    private final ArrayList newNotifies = new ArrayList();
    private long maxServiceLease;
    private long maxEventLease;
    private long minSvcExpiration = Long.MAX_VALUE;
    private long minEventExpiration = Long.MAX_VALUE;
    private LookupDiscoveryManager discoer;
    private JoinManager joiner;
    private final TaskManager tasker = new TaskManager(10, 15000L, 1.0f);
    private final Thread serviceExpirer = new ServiceExpireThread();
    private final Thread eventExpirer = new EventExpireThread();
    private UnicastThread unicaster;
    private Thread multicaster;
    private Thread announcer;
    private final Thread snapshotter = new SnapshotThread();
    private final ReadersWriter concurrentObj = new ReadersWriter();
    private final Object serviceNotifier = new Object();
    private final Object eventNotifier = new Object();
    private final Object snapshotNotifier = new Object();
    private final ClassResolver resolver = new ClassResolver();
    private ServiceType objectServiceType;
    private ReliableLog log;
    private boolean inRecovery;
    private int logFileSize = 0;
    private String logDirname;
    private int logToSnapshotThresh = 200;
    private float snapshotWt = 10.0f;
    private long minMaxServiceLease = 300000L;
    private long minMaxEventLease = 1800000L;
    private long minRenewalInterval = 100L;
    private int unicastPort = 0;
    private String[] memberGroups = new String[0];
    private String[] lookupGroups = new String[0];
    private LookupLocator[] lookupLocators = new LookupLocator[0];
    private Entry[] lookupAttrs;
    private int unicastTimeout = Integer.getInteger("com.sun.jini.reggie.unicastTimeout", 60000);
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$com$sun$jini$reggie$RegistrarImpl;

    RegistrarImpl(String string) throws IOException {
        UnicastRemoteObject.exportObject(this);
        this.logDirname = string;
        this.init();
    }

    public RegistrarImpl(ActivationID activationID, MarshalledObject marshalledObject) throws IOException {
        this.activationID = activationID;
        Activatable.exportObject((Remote)this, (ActivationID)activationID, (int)0);
        try {
            this.logDirname = (String)marshalledObject.get();
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("bad directory name in descriptor");
        }
        this.init();
    }

    static /* synthetic */ int access$14(RegistrarImpl registrarImpl) {
        return registrarImpl.unicastPort;
    }

    static /* synthetic */ long access$16(RegistrarImpl registrarImpl) {
        return registrarImpl.minMaxServiceLease;
    }

    static /* synthetic */ long access$18(RegistrarImpl registrarImpl) {
        return registrarImpl.minMaxEventLease;
    }

    static /* synthetic */ long access$20(RegistrarImpl registrarImpl) {
        return registrarImpl.minRenewalInterval;
    }

    static /* synthetic */ float access$22(RegistrarImpl registrarImpl) {
        return registrarImpl.snapshotWt;
    }

    static /* synthetic */ String[] access$24(RegistrarImpl registrarImpl) {
        return registrarImpl.lookupGroups;
    }

    static /* synthetic */ LookupLocator[] access$26(RegistrarImpl registrarImpl) {
        return registrarImpl.lookupLocators;
    }

    static /* synthetic */ int access$28(RegistrarImpl registrarImpl) {
        return registrarImpl.logToSnapshotThresh;
    }

    static /* synthetic */ int access$75(RegistrarImpl registrarImpl) {
        return registrarImpl.logFileSize;
    }

    private HashMap addAttr(SvcReg svcReg, EntryClass entryClass, int n, Object object) {
        ArrayList<SvcReg> arrayList;
        HashMap hashMap;
        HashMap[] hashMapArray = (HashMap[])this.serviceByAttr.get(entryClass);
        if (hashMapArray == null) {
            hashMapArray = new HashMap[entryClass.getNumFields()];
            this.serviceByAttr.put(entryClass, hashMapArray);
        }
        if ((hashMap = hashMapArray[n]) == null) {
            hashMapArray[n] = hashMap = new HashMap(11);
        }
        if ((arrayList = (ArrayList<SvcReg>)hashMap.get(object)) == null) {
            arrayList = new ArrayList<SvcReg>(3);
            hashMap.put(object, arrayList);
        } else if (arrayList.contains(svcReg)) {
            return hashMap;
        }
        arrayList.add(svcReg);
        return hashMap;
    }

    public void addAttributes(ServiceID serviceID, long l, EntryRep[] entryRepArray) throws UnknownLeaseException {
        if (serviceID.equals(this.myServiceID)) {
            throw new SecurityException("privileged service id");
        }
        this.concurrentObj.writeLock();
        try {
            this.addAttributesDo(serviceID, l, entryRepArray);
            this.addLogRecord(new AttrsAddedLogObj(serviceID, l, entryRepArray));
        }
        finally {
            Object var6_4 = null;
            this.concurrentObj.writeUnlock();
        }
    }

    private void addAttributesDo(ServiceID serviceID, long l, EntryRep[] entryRepArray) throws UnknownLeaseException {
        this.resolver.resolve(entryRepArray);
        long l2 = System.currentTimeMillis();
        SvcReg svcReg = (SvcReg)this.serviceByID.get(serviceID);
        if (svcReg == null || svcReg.leaseID != l || svcReg.leaseExpiration <= l2) {
            throw new UnknownLeaseException();
        }
        Item item = (Item)svcReg.item.clone();
        Object[] objectArray = svcReg.item.attributeSets;
        int n = 0;
        int n2 = 0;
        while (n2 < entryRepArray.length) {
            EntryRep entryRep = entryRepArray[n2];
            if (RegistrarImpl.indexOf(objectArray, entryRep) < 0 && RegistrarImpl.indexOf(entryRepArray, n2, entryRep) < 0) {
                entryRepArray[n++] = entryRep;
                this.addAttrs(svcReg, entryRep);
            }
            ++n2;
        }
        if (n > 0) {
            int n3 = objectArray.length;
            EntryRep[] entryRepArray2 = new EntryRep[n3 + n];
            System.arraycopy(objectArray, 0, entryRepArray2, 0, n3);
            System.arraycopy(entryRepArray, 0, entryRepArray2, n3, n);
            svcReg.item.attributeSets = entryRepArray2;
        }
        this.generateEvents(item, svcReg.item, l2);
        this.queueEvents();
    }

    private void addAttrs(SvcReg svcReg, EntryRep entryRep) {
        EntryClass entryClass = entryRep.eclass;
        this.addInstance(entryClass);
        Object[] objectArray = entryRep.fields;
        if (objectArray.length > 0) {
            int n = objectArray.length;
            while (--n >= 0) {
                entryClass = RegistrarImpl.getDefiningClass(entryClass, n);
                this.addAttr(svcReg, entryClass, n, objectArray[n]);
            }
            return;
        }
        ArrayList<SvcReg> arrayList = (ArrayList<SvcReg>)this.serviceByEmptyAttr.get(entryClass);
        if (arrayList == null) {
            arrayList = new ArrayList<SvcReg>(2);
            arrayList.add(svcReg);
            this.serviceByEmptyAttr.put(entryClass, arrayList);
        } else if (!arrayList.contains(svcReg)) {
            arrayList.add(svcReg);
        }
    }

    private static void addConcreteClass(ServiceType serviceType, ServiceType serviceType2) {
        Object[] objectArray = serviceType.getConcreteClasses();
        if (RegistrarImpl.indexOf(objectArray, serviceType2) >= 0) {
            return;
        }
        serviceType.setConcreteClasses((ServiceType[])RegistrarImpl.arrayAdd(objectArray, serviceType2));
        ServiceType[] serviceTypeArray = serviceType.getInterfaces();
        int n = serviceTypeArray.length;
        while (--n >= 0) {
            RegistrarImpl.addConcreteClass(serviceTypeArray[n], serviceType2);
        }
        ServiceType serviceType3 = serviceType.getSuperclass();
        if (serviceType3 != null) {
            RegistrarImpl.addConcreteClass(serviceType3, serviceType2);
        }
    }

    private void addEvent(EventReg eventReg) {
        if (eventReg.listener == null) {
            return;
        }
        Long l = new Long(eventReg.eventID);
        this.eventByID.put(l, eventReg);
        this.eventByTime.put(eventReg, eventReg);
        if (eventReg.tmpl.serviceID != null) {
            Object object = this.subEventByService.get(eventReg.tmpl.serviceID);
            object = object == null ? eventReg : (object instanceof EventReg ? new EventReg[]{(EventReg)object, eventReg} : RegistrarImpl.arrayAdd((EventReg[])object, eventReg));
            this.subEventByService.put(eventReg.tmpl.serviceID, object);
        } else {
            this.subEventByID.put(l, eventReg);
        }
        this.computeMaxLeases();
    }

    private void addInstance(EntryClass entryClass) {
        int n = entryClass.getNumInstances();
        if (n == 0) {
            this.entryClasses.add(entryClass);
        }
        entryClass.setNumInstances(n + 1);
    }

    private void addLogRecord(LogRecord logRecord) {
        try {
            int n;
            this.log.update(logRecord, true);
            if (++this.logFileSize >= this.logToSnapshotThresh && (float)this.logFileSize >= this.snapshotWt * (float)(n = this.serviceByID.size() + this.eventByID.size())) {
                this.concurrentObj.waiterNotify(this.snapshotNotifier);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addLookupAttributes(Entry[] entryArray) throws RemoteException {
        this.concurrentObj.writeLock();
        try {
            this.joiner.addAttributes(entryArray, true);
            this.lookupAttrs = this.joiner.getAttributes();
            EntryRep[] entryRepArray = EntryRep.toEntryRep(entryArray, true);
            try {
                this.addAttributesDo(this.myServiceID, 0L, entryRepArray);
            }
            catch (UnknownLeaseException unknownLeaseException) {}
            this.addLogRecord(new AttrsAddedLogObj(this.myServiceID, 0L, entryRepArray));
        }
        finally {
            Object var3_3 = null;
            this.concurrentObj.writeUnlock();
        }
    }

    public void addLookupGroups(String[] stringArray) throws RemoteException {
        this.concurrentObj.writeLock();
        try {
            try {
                this.discoer.addGroups(stringArray);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.toString());
            }
            this.lookupGroups = this.discoer.getGroups();
            this.addLogRecord(new LookupGroupsChangedLogObj(this.lookupGroups));
        }
        finally {
            Object var3_3 = null;
            this.concurrentObj.writeUnlock();
        }
    }

    public void addLookupLocators(LookupLocator[] lookupLocatorArray) throws RemoteException {
        this.concurrentObj.writeLock();
        try {
            this.discoer.addLocators(lookupLocatorArray);
            this.lookupLocators = this.discoer.getLocators();
            this.addLogRecord(new LookupLocatorsChangedLogObj(this.lookupLocators));
        }
        finally {
            Object var3_2 = null;
            this.concurrentObj.writeUnlock();
        }
    }

    public void addMemberGroups(String[] stringArray) throws RemoteException {
        this.concurrentObj.writeLock();
        try {
            int n = 0;
            while (n < stringArray.length) {
                if (RegistrarImpl.indexOf(this.memberGroups, stringArray[n]) < 0) {
                    this.memberGroups = (String[])RegistrarImpl.arrayAdd(this.memberGroups, stringArray[n]);
                }
                ++n;
            }
            Thread thread = this.announcer;
            synchronized (thread) {
                this.announcer.notify();
            }
            this.addLogRecord(new MemberGroupsChangedLogObj(this.memberGroups));
        }
        finally {
            Object var3_4 = null;
            this.concurrentObj.writeUnlock();
        }
    }

    private void addService(SvcReg svcReg) {
        this.serviceByID.put(svcReg.item.serviceID, svcReg);
        this.serviceByTime.put(svcReg, svcReg);
        ServiceType serviceType = svcReg.item.serviceType;
        ArrayList<SvcReg> arrayList = (ArrayList<SvcReg>)this.serviceByType.get(serviceType);
        if (arrayList == null) {
            arrayList = new ArrayList<SvcReg>(3);
            this.serviceByType.put(serviceType, arrayList);
            RegistrarImpl.addConcreteClass(serviceType, serviceType);
        }
        arrayList.add(svcReg);
        EntryRep[] entryRepArray = svcReg.item.attributeSets;
        int n = entryRepArray.length;
        while (--n >= 0) {
            this.addAttrs(svcReg, entryRepArray[n]);
        }
        this.computeMaxLeases();
    }

    private static void addTypes(ArrayList arrayList, ArrayList arrayList2, ServiceType[] serviceTypeArray, String string, ServiceType serviceType, String string2) {
        if (arrayList.contains(serviceType)) {
            return;
        }
        if (serviceTypeArray != null) {
            int n = serviceTypeArray.length;
            while (--n >= 0) {
                if (!serviceType.isAssignableFrom(serviceTypeArray[n])) continue;
                return;
            }
        }
        if (string == null || serviceType.getName().startsWith(string)) {
            arrayList.add(serviceType);
            arrayList2.add(string2);
            return;
        }
        ServiceType[] serviceTypeArray2 = serviceType.getInterfaces();
        int n = serviceTypeArray2.length;
        while (--n >= 0) {
            RegistrarImpl.addTypes(arrayList, arrayList2, serviceTypeArray, string, serviceTypeArray2[n], string2);
        }
        ServiceType serviceType2 = serviceType.getSuperclass();
        if (serviceType2 != null) {
            RegistrarImpl.addTypes(arrayList, arrayList2, serviceTypeArray, string, serviceType2, string2);
        }
    }

    private static boolean allNull(Object[] objectArray) {
        int n = objectArray.length;
        while (--n >= 0) {
            if (objectArray[n] == null) continue;
            return false;
        }
        return true;
    }

    private static Object[] arrayAdd(Object[] objectArray, Object object) {
        int n = objectArray.length;
        Object[] objectArray2 = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n + 1);
        System.arraycopy(objectArray, 0, objectArray2, 0, n);
        objectArray2[n] = object;
        return objectArray2;
    }

    private static Object[] arrayDel(Object[] objectArray, int n) {
        int n2 = objectArray.length - 1;
        Object[] objectArray2 = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n2);
        System.arraycopy(objectArray, 0, objectArray2, 0, n);
        System.arraycopy(objectArray, n + 1, objectArray2, n, n2 - n);
        return objectArray2;
    }

    private static boolean attrMatch(EntryRep[] entryRepArray, EntryRep entryRep) {
        boolean bl = true;
        if (entryRepArray != null) {
            int n = entryRepArray.length;
            while (--n >= 0) {
                EntryRep entryRep2 = entryRepArray[n];
                if (!RegistrarImpl.matchEntry(entryRep2, entryRep)) continue;
                if (entryRep2.eclass.isAssignableFrom(entryRep.eclass) && !entryRep2.eclass.equals(entryRep.eclass)) {
                    return true;
                }
                bl = false;
            }
        }
        return bl;
    }

    public void cancelEventLease(long l, long l2) throws UnknownLeaseException {
        this.concurrentObj.writeLock();
        try {
            this.cancelEventLeaseDo(l, l2);
            this.addLogRecord(new EventLeaseCancelledLogObj(l, l2));
        }
        finally {
            Object var6_3 = null;
            this.concurrentObj.writeUnlock();
        }
    }

    private void cancelEventLeaseDo(long l, long l2) throws UnknownLeaseException {
        long l3 = System.currentTimeMillis();
        EventReg eventReg = (EventReg)this.eventByID.get(new Long(l));
        if (eventReg == null || eventReg.leaseExpiration <= l3) {
            throw new UnknownLeaseException();
        }
        this.deleteEvent(eventReg);
        if (eventReg.leaseExpiration == this.minEventExpiration) {
            this.concurrentObj.waiterNotify(this.eventNotifier);
        }
    }

    public Exception[] cancelLeases(Object[] objectArray, long[] lArray) {
        this.concurrentObj.writeLock();
        try {
            this.addLogRecord(new LeasesCancelledLogObj(objectArray, lArray));
            Exception[] exceptionArray = this.cancelLeasesDo(objectArray, lArray);
            Object var5_4 = null;
            this.concurrentObj.writeUnlock();
            return exceptionArray;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
    }

    private Exception[] cancelLeasesDo(Object[] objectArray, long[] lArray) {
        Exception[] exceptionArray = null;
        int n = objectArray.length;
        while (--n >= 0) {
            Object object = objectArray[n];
            try {
                if (object instanceof ServiceID) {
                    this.cancelServiceLeaseDo((ServiceID)object, lArray[n]);
                    continue;
                }
                this.cancelEventLeaseDo((Long)object, lArray[n]);
            }
            catch (Exception exception) {
                if (exceptionArray == null) {
                    exceptionArray = new Exception[objectArray.length];
                }
                exceptionArray[n] = exception;
            }
        }
        return exceptionArray;
    }

    public void cancelServiceLease(ServiceID serviceID, long l) throws UnknownLeaseException {
        this.concurrentObj.writeLock();
        try {
            this.cancelServiceLeaseDo(serviceID, l);
            this.addLogRecord(new ServiceLeaseCancelledLogObj(serviceID, l));
        }
        finally {
            Object var5_3 = null;
            this.concurrentObj.writeUnlock();
        }
    }

    private void cancelServiceLeaseDo(ServiceID serviceID, long l) throws UnknownLeaseException {
        if (serviceID.equals(this.myServiceID)) {
            throw new SecurityException("privileged service id");
        }
        long l2 = System.currentTimeMillis();
        SvcReg svcReg = (SvcReg)this.serviceByID.get(serviceID);
        if (svcReg == null || svcReg.leaseID != l || svcReg.leaseExpiration <= l2) {
            throw new UnknownLeaseException();
        }
        this.deleteService(svcReg, l2);
        if (svcReg.leaseExpiration == this.minSvcExpiration) {
            this.concurrentObj.waiterNotify(this.serviceNotifier);
        }
        this.queueEvents();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private void closeRequestSockets(ArrayList arrayList) {
        int n = arrayList.size();
        while (--n >= 0) {
            Object e = arrayList.get(n);
            if (!(e instanceof SocketTask)) continue;
            try {
                ((SocketTask)e).socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void computeMaxLeases() {
        if (this.inRecovery) {
            return;
        }
        this.maxServiceLease = Math.max(this.minMaxServiceLease, this.minRenewalInterval * ((long)this.serviceByID.size() + (long)this.eventByID.size() * this.minMaxServiceLease / this.minMaxEventLease));
        this.maxEventLease = Math.max(this.minMaxEventLease, this.maxServiceLease * this.minMaxEventLease / this.minMaxServiceLease);
    }

    private static Item copyItem(Item item) {
        item = (Item)item.clone();
        item.serviceType = null;
        item.codebase = null;
        EntryRep[] entryRepArray = item.attributeSets;
        int n = entryRepArray.length;
        while (--n >= 0) {
            entryRepArray[n].eclass = entryRepArray[n].eclass.getReplacement();
        }
        return item;
    }

    private void deleteAttrs(SvcReg svcReg, EntryRep entryRep, boolean bl) {
        EntryClass entryClass = entryRep.eclass;
        this.deleteInstance(entryClass);
        Object[] objectArray = entryRep.fields;
        if (objectArray.length == 0) {
            ArrayList arrayList = (ArrayList)this.serviceByEmptyAttr.get(entryClass);
            if (arrayList == null || bl && RegistrarImpl.hasEmptyAttr(svcReg, entryClass)) {
                return;
            }
            int n = arrayList.indexOf(svcReg);
            if (n >= 0) {
                arrayList.remove(n);
                if (arrayList.isEmpty()) {
                    this.serviceByEmptyAttr.remove(entryClass);
                }
            }
            return;
        }
        int n = objectArray.length;
        while (--n >= 0) {
            int n2;
            Object object;
            HashMap hashMap;
            ArrayList arrayList;
            Object[] objectArray2 = (HashMap[])this.serviceByAttr.get(entryClass = RegistrarImpl.getDefiningClass(entryClass, n));
            if (objectArray2 == null || objectArray2[n] == null || bl && RegistrarImpl.hasAttr(svcReg, entryClass, n, objectArray[n]) || (arrayList = (ArrayList)(hashMap = objectArray2[n]).get(object = objectArray[n])) == null || (n2 = arrayList.indexOf(svcReg)) < 0) continue;
            arrayList.remove(n2);
            if (!arrayList.isEmpty()) continue;
            hashMap.remove(object);
            if (!hashMap.isEmpty()) continue;
            objectArray2[n] = null;
            if (!RegistrarImpl.allNull(objectArray2)) continue;
            this.serviceByAttr.remove(entryClass);
        }
    }

    private static void deleteConcreteClass(ServiceType serviceType, ServiceType serviceType2) {
        Object[] objectArray = serviceType.getConcreteClasses();
        int n = RegistrarImpl.indexOf(objectArray, serviceType2);
        if (n >= 0) {
            serviceType.setConcreteClasses((ServiceType[])RegistrarImpl.arrayDel(objectArray, n));
            ServiceType[] serviceTypeArray = serviceType.getInterfaces();
            int n2 = serviceTypeArray.length;
            while (--n2 >= 0) {
                RegistrarImpl.deleteConcreteClass(serviceTypeArray[n2], serviceType2);
            }
            ServiceType serviceType3 = serviceType.getSuperclass();
            if (serviceType3 != null) {
                RegistrarImpl.deleteConcreteClass(serviceType3, serviceType2);
            }
        }
    }

    private void deleteEvent(EventReg eventReg) {
        Long l = new Long(eventReg.eventID);
        this.eventByID.remove(l);
        this.eventByTime.remove(eventReg);
        if (eventReg.tmpl.serviceID != null) {
            Object object = this.subEventByService.get(eventReg.tmpl.serviceID);
            if (object == eventReg) {
                this.subEventByService.remove(eventReg.tmpl.serviceID);
            } else {
                Object[] objectArray = (EventReg[])object;
                object = (objectArray = RegistrarImpl.arrayDel(objectArray, RegistrarImpl.indexOf(objectArray, eventReg))).length == 1 ? objectArray[0] : objectArray;
                this.subEventByService.put(eventReg.tmpl.serviceID, object);
            }
        } else {
            this.subEventByID.remove(l);
        }
        this.computeMaxLeases();
    }

    private void deleteInstance(EntryClass entryClass) {
        int n = entryClass.getNumInstances() - 1;
        if (n == 0) {
            this.entryClasses.remove(this.entryClasses.indexOf(entryClass));
        }
        entryClass.setNumInstances(n);
    }

    private void deleteService(SvcReg svcReg, long l) {
        Item item = svcReg.item;
        this.generateEvents(item, null, l);
        this.serviceByID.remove(item.serviceID);
        this.serviceByTime.remove(svcReg);
        ServiceType serviceType = item.serviceType;
        ArrayList arrayList = (ArrayList)this.serviceByType.get(serviceType);
        arrayList.remove(arrayList.indexOf(svcReg));
        if (arrayList.isEmpty()) {
            this.serviceByType.remove(serviceType);
            RegistrarImpl.deleteConcreteClass(serviceType, serviceType);
        }
        EntryRep[] entryRepArray = item.attributeSets;
        int n = entryRepArray.length;
        while (--n >= 0) {
            this.deleteAttrs(svcReg, entryRepArray[n], false);
        }
        this.computeMaxLeases();
    }

    private static EntryRep[] deleteSet(Item item, int n) {
        item.attributeSets = (EntryRep[])RegistrarImpl.arrayDel(item.attributeSets, n);
        return item.attributeSets;
    }

    public void destroy() {
        new DestroyThread().start();
    }

    private void generateEvent(EventReg eventReg, Item item, Item item2, ServiceID serviceID, long l) {
        if (eventReg.leaseExpiration <= l) {
            return;
        }
        if ((eventReg.transitions & 2) != 0 && (item == null || !RegistrarImpl.matchItem(eventReg.tmpl, item)) && item2 != null && RegistrarImpl.matchItem(eventReg.tmpl, item2)) {
            this.pendingEvent(eventReg, serviceID, item2, 2);
        } else if ((eventReg.transitions & 1) != 0 && item != null && RegistrarImpl.matchItem(eventReg.tmpl, item) && (item2 == null || !RegistrarImpl.matchItem(eventReg.tmpl, item2))) {
            this.pendingEvent(eventReg, serviceID, item2, 1);
        } else if ((eventReg.transitions & 4) != 0 && item != null && RegistrarImpl.matchItem(eventReg.tmpl, item) && item2 != null && RegistrarImpl.matchItem(eventReg.tmpl, item2)) {
            this.pendingEvent(eventReg, serviceID, item2, 4);
        }
    }

    private void generateEvents(Item item, Item item2, long l) {
        Object object;
        if (this.inRecovery) {
            return;
        }
        ServiceID serviceID = item != null ? item.serviceID : item2.serviceID;
        Object v = this.subEventByService.get(serviceID);
        if (v instanceof EventReg) {
            this.generateEvent((EventReg)v, item, item2, serviceID, l);
        } else if (v != null) {
            object = (EventReg[])v;
            int n = ((EventReg[])object).length;
            while (--n >= 0) {
                this.generateEvent((EventReg)object[n], item, item2, serviceID, l);
            }
        }
        object = this.subEventByID.values().iterator();
        while (object.hasNext()) {
            this.generateEvent((EventReg)object.next(), item, item2, serviceID, l);
        }
    }

    public Object getAdmin() throws RemoteException {
        return new RegistrarAdminProxy(this, this.myServiceID);
    }

    private static EntryClass getDefiningClass(EntryClass entryClass, int n) {
        EntryClass entryClass2;
        while ((entryClass2 = entryClass.getSuperclass()).getNumFields() > n) {
            entryClass = entryClass2;
        }
        return entryClass;
    }

    private EntryClass getEmptyEntryClass(EntryClass entryClass) {
        EntryClass entryClass2 = null;
        int n = this.entryClasses.size();
        while (--n >= 0) {
            EntryClass entryClass3 = (EntryClass)this.entryClasses.get(n);
            if (!entryClass.isAssignableFrom(entryClass3)) continue;
            if (entryClass3.getNumFields() != 0 || entryClass2 != null) {
                return null;
            }
            entryClass2 = entryClass3;
        }
        return entryClass2;
    }

    public EntryClassBase[] getEntryClasses(Template template) {
        this.concurrentObj.readLock();
        try {
            EntryClassBase[] entryClassBaseArray = this.getEntryClassesDo(template);
            Object var4_3 = null;
            this.concurrentObj.readUnlock();
            return entryClassBaseArray;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.concurrentObj.readUnlock();
            throw throwable;
        }
    }

    private EntryClassBase[] getEntryClassesDo(Template template) {
        Serializable serializable;
        int n;
        this.resolver.resolve(template);
        ArrayList<EntryClass> arrayList = new ArrayList<EntryClass>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (template.serviceID == null && RegistrarImpl.isEmpty(template.serviceTypes) && RegistrarImpl.isEmpty(template.attributeSetTemplates)) {
            long l = System.currentTimeMillis();
            n = this.entryClasses.size();
            while (--n >= 0) {
                serializable = (EntryClass)this.entryClasses.get(n);
                try {
                    arrayList2.add(this.pickCodebase((EntryClass)serializable, l));
                    arrayList.add((EntryClass)serializable);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
        } else {
            ItemIter itemIter = this.matchingItems(template);
            while (itemIter.hasNext()) {
                Item item = itemIter.next();
                n = item.attributeSets.length;
                while (--n >= 0) {
                    serializable = item.attributeSets[n];
                    if (!RegistrarImpl.attrMatch(template.attributeSetTemplates, (EntryRep)serializable) || arrayList.contains(((EntryRep)serializable).eclass)) continue;
                    arrayList.add(((EntryRep)serializable).eclass);
                    arrayList2.add(((EntryRep)serializable).codebase);
                }
            }
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        EntryClassBase[] entryClassBaseArray = new EntryClassBase[arrayList.size()];
        int n2 = entryClassBaseArray.length;
        while (--n2 >= 0) {
            entryClassBaseArray[n2] = new EntryClassBase(((EntryClass)arrayList.get(n2)).getReplacement(), (String)arrayList2.get(n2));
        }
        return entryClassBaseArray;
    }

    public Object[] getFieldValues(Template template, int n, int n2) {
        this.concurrentObj.readLock();
        try {
            Object[] objectArray = this.getFieldValuesDo(template, n, n2);
            Object var6_5 = null;
            this.concurrentObj.readUnlock();
            return objectArray;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.concurrentObj.readUnlock();
            throw throwable;
        }
    }

    private Object[] getFieldValuesDo(Template template, int n, int n2) {
        this.resolver.resolve(template);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        EntryRep entryRep = template.attributeSetTemplates[n];
        if (template.serviceID == null && RegistrarImpl.isEmpty(template.serviceTypes) && template.attributeSetTemplates.length == 1 && RegistrarImpl.allNull(entryRep.fields)) {
            long l = System.currentTimeMillis();
            EntryClass entryClass = RegistrarImpl.getDefiningClass(entryRep.eclass, n2);
            boolean bl = entryClass.equals(entryRep.eclass) ^ true;
            HashMap[] hashMapArray = (HashMap[])this.serviceByAttr.get(entryClass);
            if (hashMapArray != null && hashMapArray[n2] != null) {
                Iterator iterator = hashMapArray[n2].entrySet().iterator();
                block0: while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    ArrayList arrayList2 = (ArrayList)entry.getValue();
                    Object k = entry.getKey();
                    int n3 = arrayList2.size();
                    while (--n3 >= 0) {
                        SvcReg svcReg = (SvcReg)arrayList2.get(n3);
                        if (svcReg.leaseExpiration <= l || bl && !RegistrarImpl.hasAttr(svcReg, entryRep.eclass, n2, k)) continue;
                        arrayList.add(k);
                        continue block0;
                    }
                }
            }
        } else {
            ItemIter itemIter = this.matchingItems(template);
            while (itemIter.hasNext()) {
                Item item = itemIter.next();
                int n4 = item.attributeSets.length;
                while (--n4 >= 0) {
                    Object object;
                    if (!RegistrarImpl.matchEntry(entryRep, item.attributeSets[n4]) || arrayList.contains(object = item.attributeSets[n4].fields[n2])) continue;
                    arrayList.add(object);
                }
            }
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray();
    }

    public LookupLocator getLocator() {
        return this.myLocator;
    }

    public int getLogToSnapshotThreshold() throws RemoteException {
        this.concurrentObj.readLock();
        try {
            int n = this.logToSnapshotThresh;
            Object var3_2 = null;
            this.concurrentObj.readUnlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.concurrentObj.readUnlock();
            throw throwable;
        }
    }

    public Entry[] getLookupAttributes() throws RemoteException {
        this.concurrentObj.readLock();
        try {
            Entry[] entryArray = this.lookupAttrs;
            Object var3_2 = null;
            this.concurrentObj.readUnlock();
            return entryArray;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.concurrentObj.readUnlock();
            throw throwable;
        }
    }

    public String[] getLookupGroups() throws RemoteException {
        this.concurrentObj.readLock();
        try {
            String[] stringArray = this.lookupGroups;
            Object var3_2 = null;
            this.concurrentObj.readUnlock();
            return stringArray;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.concurrentObj.readUnlock();
            throw throwable;
        }
    }

    public LookupLocator[] getLookupLocators() throws RemoteException {
        this.concurrentObj.readLock();
        try {
            LookupLocator[] lookupLocatorArray = this.lookupLocators;
            Object var3_2 = null;
            this.concurrentObj.readUnlock();
            return lookupLocatorArray;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.concurrentObj.readUnlock();
            throw throwable;
        }
    }

    public String[] getMemberGroups() {
        this.concurrentObj.readLock();
        try {
            String[] stringArray = this.memberGroups;
            Object var3_2 = null;
            this.concurrentObj.readUnlock();
            return stringArray;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.concurrentObj.readUnlock();
            throw throwable;
        }
    }

    public long getMinMaxEventLease() throws RemoteException {
        this.concurrentObj.readLock();
        try {
            long l = this.minMaxEventLease;
            Object var4_2 = null;
            this.concurrentObj.readUnlock();
            return l;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.concurrentObj.readUnlock();
            throw throwable;
        }
    }

    public long getMinMaxServiceLease() throws RemoteException {
        this.concurrentObj.readLock();
        try {
            long l = this.minMaxServiceLease;
            Object var4_2 = null;
            this.concurrentObj.readUnlock();
            return l;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.concurrentObj.readUnlock();
            throw throwable;
        }
    }

    public long getMinRenewalInterval() throws RemoteException {
        this.concurrentObj.readLock();
        try {
            long l = this.minRenewalInterval;
            Object var4_2 = null;
            this.concurrentObj.readUnlock();
            return l;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.concurrentObj.readUnlock();
            throw throwable;
        }
    }

    public ServiceID getServiceID() {
        return this.myServiceID;
    }

    public ServiceTypeBase[] getServiceTypes(Template template, String string) {
        this.concurrentObj.readLock();
        try {
            ServiceTypeBase[] serviceTypeBaseArray = this.getServiceTypesDo(template, string);
            Object var5_4 = null;
            this.concurrentObj.readUnlock();
            return serviceTypeBaseArray;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.concurrentObj.readUnlock();
            throw throwable;
        }
    }

    private ServiceTypeBase[] getServiceTypesDo(Template template, String string) {
        this.resolver.resolve(template);
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        if (template.serviceID == null && RegistrarImpl.isEmpty(template.attributeSetTemplates)) {
            long l = System.currentTimeMillis();
            ServiceType[] serviceTypeArray = this.matchingConcreteClasses(template.serviceTypes);
            int n = serviceTypeArray.length;
            while (--n >= 0) {
                try {
                    RegistrarImpl.addTypes(arrayList, arrayList2, template.serviceTypes, string, serviceTypeArray[n], this.pickCodebase(serviceTypeArray[n], l));
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
        } else {
            ItemIter itemIter = this.matchingItems(template);
            while (itemIter.hasNext()) {
                Item item = itemIter.next();
                RegistrarImpl.addTypes(arrayList, arrayList2, template.serviceTypes, string, item.serviceType, item.codebase);
            }
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        ServiceTypeBase[] serviceTypeBaseArray = new ServiceTypeBase[arrayList.size()];
        int n = serviceTypeBaseArray.length;
        while (--n >= 0) {
            serviceTypeBaseArray[n] = new ServiceTypeBase(((ServiceType)arrayList.get(n)).getReplacement(), (String)arrayList2.get(n));
        }
        return serviceTypeBaseArray;
    }

    public float getSnapshotWeight() throws RemoteException {
        this.concurrentObj.readLock();
        try {
            float f = this.snapshotWt;
            Object var3_2 = null;
            this.concurrentObj.readUnlock();
            return f;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.concurrentObj.readUnlock();
            throw throwable;
        }
    }

    public String getStorageLocation() throws RemoteException {
        this.concurrentObj.readLock();
        try {
            String string = this.logDirname;
            Object var3_2 = null;
            this.concurrentObj.readUnlock();
            return string;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.concurrentObj.readUnlock();
            throw throwable;
        }
    }

    public int getUnicastPort() throws RemoteException {
        this.concurrentObj.readLock();
        try {
            int n = this.unicastPort;
            Object var3_2 = null;
            this.concurrentObj.readUnlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.concurrentObj.readUnlock();
            throw throwable;
        }
    }

    private static boolean hasAttr(SvcReg svcReg, EntryClass entryClass, int n, Object object) {
        EntryRep[] entryRepArray = svcReg.item.attributeSets;
        int n2 = entryRepArray.length;
        while (--n2 >= 0) {
            EntryRep entryRep = entryRepArray[n2];
            if (!entryClass.isAssignableFrom(entryRep.eclass) || (object != null || entryRep.fields[n] != null) && (object == null || !object.equals(entryRep.fields[n]))) continue;
            return true;
        }
        return false;
    }

    private static boolean hasEmptyAttr(SvcReg svcReg, EntryClass entryClass) {
        EntryRep[] entryRepArray = svcReg.item.attributeSets;
        int n = entryRepArray.length;
        while (--n >= 0) {
            if (!entryClass.equals(entryRepArray[n].eclass)) continue;
            return true;
        }
        return false;
    }

    private static int indexOf(Object[] objectArray, int n, Object object) {
        int n2 = 0;
        while (n2 < n) {
            if (object.equals(objectArray[n2])) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private static int indexOf(Object[] objectArray, Object object) {
        return RegistrarImpl.indexOf(objectArray, objectArray.length, object);
    }

    private void init() throws IOException {
        this.objectServiceType = this.resolver.resolve(new ServiceType(class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = RegistrarImpl.class$("java.lang.Object")), null, null));
        String string = System.getProperty("java.rmi.server.hostname");
        if (string == null) {
            string = InetAddress.getLocalHost().getHostName();
        }
        this.log = new ReliableLog(this.logDirname, new LocalLogHandler());
        this.inRecovery = true;
        this.log.recover();
        this.inRecovery = false;
        this.computeMaxLeases();
        this.unicaster = new UnicastThread(this.unicastPort);
        this.myLocator = new LookupLocator(string, this.unicaster.port);
        this.multicaster = new MulticastThread();
        this.announcer = new AnnounceThread();
        if (this.myServiceID == null) {
            this.myServiceID = this.newServiceID();
        }
        this.proxy = new RegistrarProxy((Registrar)RemoteObject.toStub(this), this.myServiceID);
        if (this.serviceByID.isEmpty()) {
            this.lookupAttrs = new Entry[]{new ServiceInfo(PRODUCT, "Sun Microsystems, Inc.", "Sun Microsystems, Inc.", VERSION, "", ""), new BasicServiceType(PRODUCT)};
            Item item = new Item(new ServiceItem(this.myServiceID, this.proxy, this.lookupAttrs));
            this.resolver.resolve(item);
            SvcReg svcReg = new SvcReg(item, 0L, Long.MAX_VALUE);
            this.addService(svcReg);
        } else {
            SvcReg svcReg = (SvcReg)this.serviceByID.get(this.myServiceID);
            this.lookupAttrs = EntryRep.toEntry(svcReg.item.attributeSets);
            int n = this.lookupAttrs.length;
            while (--n >= 0) {
                if (this.lookupAttrs[n] != null) continue;
                this.lookupAttrs = (Entry[])RegistrarImpl.arrayDel(this.lookupAttrs, n);
                EntryRep entryRep = svcReg.item.attributeSets[n];
                RegistrarImpl.deleteSet(svcReg.item, n);
                this.deleteAttrs(svcReg, entryRep, true);
            }
        }
        this.log.snapshot();
        this.discoer = new LookupDiscoveryManager(this.lookupGroups, this.lookupLocators, null);
        this.joiner = new JoinManager((Object)this.proxy, this.lookupAttrs, this.myServiceID, (DiscoveryManagement)this.discoer, null);
        this.serviceExpirer.start();
        this.eventExpirer.start();
        this.unicaster.start();
        this.multicaster.start();
        this.announcer.start();
        this.snapshotter.start();
    }

    private static boolean isEmpty(Object[] objectArray) {
        return objectArray == null || objectArray.length == 0;
    }

    private static long limitDuration(long l, long l2) {
        if (l == -1L || l > l2) {
            l = l2;
        } else if (l < 0L) {
            throw new IllegalArgumentException("negative lease duration");
        }
        return l;
    }

    public MarshalledObject lookup(Template template) {
        this.concurrentObj.readLock();
        try {
            MarshalledObject marshalledObject = this.lookupDo(template);
            Object var4_3 = null;
            this.concurrentObj.readUnlock();
            return marshalledObject;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.concurrentObj.readUnlock();
            throw throwable;
        }
    }

    public Matches lookup(Template template, int n) {
        this.concurrentObj.readLock();
        try {
            Matches matches = this.lookupDo(template, n);
            Object var5_4 = null;
            this.concurrentObj.readUnlock();
            return matches;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.concurrentObj.readUnlock();
            throw throwable;
        }
    }

    private MarshalledObject lookupDo(Template template) {
        this.resolver.resolve(template);
        if (RegistrarImpl.isEmpty(template.serviceTypes) || template.serviceID != null) {
            ItemIter itemIter = this.matchingItems(template);
            if (itemIter.hasNext()) {
                return itemIter.next().service;
            }
            return null;
        }
        ServiceType[] serviceTypeArray = this.matchingConcreteClasses(template.serviceTypes);
        long l = System.currentTimeMillis();
        int n = serviceTypeArray.length;
        if (n == 0) {
            return null;
        }
        int n2 = Math.abs(this.random.nextInt()) % n;
        int n3 = 0;
        while (n3 < n) {
            ArrayList arrayList = (ArrayList)this.serviceByType.get(serviceTypeArray[(n3 + n2) % n]);
            int n4 = arrayList.size();
            int n5 = Math.abs(this.random.nextInt()) % n4;
            int n6 = 0;
            while (n6 < n4) {
                SvcReg svcReg = (SvcReg)arrayList.get((n6 + n5) % n4);
                if (svcReg.leaseExpiration > l && RegistrarImpl.matchAttributes(template, svcReg.item)) {
                    return svcReg.item.service;
                }
                ++n6;
            }
            ++n3;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private Matches lookupDo(Template var1_1, int var2_2) {
        block8: {
            if (var2_2 < 0) {
                throw new IllegalArgumentException("negative maxMatches");
            }
            this.resolver.resolve(var1_1);
            var3_3 = 0;
            var4_4 = null;
            var5_5 = this.matchingItems(var1_1);
            if (var2_2 > 0 || var5_5.dupsPossible) {
                var4_4 = new ArrayList<Item>();
            }
            if (!var5_5.dupsPossible) ** GOTO lbl36
            while (var5_5.hasNext()) {
                var6_6 = var5_5.next();
                if (var4_4.contains(var6_6)) continue;
                var4_4.add(var6_6);
            }
            var3_3 = var4_4.size();
            if (var2_2 > 0) {
                var6_7 = var4_4.size();
                while (--var6_7 >= var2_2) {
                    var4_4.remove(var6_7);
                }
                var7_9 = var4_4.size();
                while (--var7_9 >= 0) {
                    var4_4.set(var7_9, RegistrarImpl.copyItem((Item)var4_4.get(var7_9)));
                }
            } else {
                var4_4 = null;
            }
            break block8;
lbl-1000:
            // 1 sources

            {
                var6_8 = var5_5.next();
                ++var3_3;
                if (--var2_2 < 0) continue;
                var4_4.add(RegistrarImpl.copyItem(var6_8));
lbl36:
                // 3 sources

                ** while (var5_5.hasNext())
            }
        }
        return new Matches(var4_4, var3_3);
    }

    private static boolean matchAttributes(Template template, Item item) {
        EntryRep[] entryRepArray = template.attributeSetTemplates;
        if (entryRepArray != null) {
            EntryRep[] entryRepArray2 = item.attributeSets;
            int n = entryRepArray.length;
            block0: while (--n >= 0) {
                EntryRep entryRep = entryRepArray[n];
                int n2 = entryRepArray2.length;
                while (--n2 >= 0) {
                    if (RegistrarImpl.matchEntry(entryRep, entryRepArray2[n2])) continue block0;
                }
                return false;
            }
        }
        return true;
    }

    private static boolean matchEntry(EntryRep entryRep, EntryRep entryRep2) {
        if (!entryRep.eclass.isAssignableFrom(entryRep2.eclass) || entryRep.fields.length > entryRep2.fields.length) {
            return false;
        }
        int n = entryRep.fields.length;
        while (--n >= 0) {
            if (entryRep.fields[n] == null || entryRep.fields[n].equals(entryRep2.fields[n])) continue;
            return false;
        }
        return true;
    }

    private static boolean matchItem(Template template, Item item) {
        return (template.serviceID == null || template.serviceID.equals(item.serviceID)) && RegistrarImpl.matchType(template.serviceTypes, item.serviceType) && RegistrarImpl.matchAttributes(template, item);
    }

    private static boolean matchType(ServiceType[] serviceTypeArray, ServiceType serviceType) {
        if (serviceTypeArray != null) {
            int n = serviceTypeArray.length;
            while (--n >= 0) {
                if (serviceTypeArray[n].isAssignableFrom(serviceType)) continue;
                return false;
            }
        }
        return true;
    }

    private ServiceType[] matchingConcreteClasses(ServiceType[] serviceTypeArray) {
        if (RegistrarImpl.isEmpty(serviceTypeArray)) {
            return this.objectServiceType.getConcreteClasses();
        }
        Object[] objectArray = serviceTypeArray[0].getConcreteClasses();
        if (serviceTypeArray.length > 1) {
            int n = objectArray.length;
            while (--n >= 0) {
                if (RegistrarImpl.matchType(serviceTypeArray, objectArray[n])) continue;
                objectArray = (ServiceType[])RegistrarImpl.arrayDel(objectArray, n);
            }
        }
        return objectArray;
    }

    private ItemIter matchingItems(Template template) {
        if (template.serviceID != null) {
            return new IDItemIter(template);
        }
        if (!RegistrarImpl.isEmpty(template.serviceTypes)) {
            return new TypeItemIter(template);
        }
        Object[] objectArray = template.attributeSetTemplates;
        if (RegistrarImpl.isEmpty(objectArray)) {
            return new AllItemIter();
        }
        int n = objectArray.length;
        while (--n >= 0) {
            Object[] objectArray2 = ((EntryRep)objectArray[n]).fields;
            if (objectArray2.length == 0) {
                EntryClass entryClass = this.getEmptyEntryClass(((EntryRep)objectArray[n]).eclass);
                if (entryClass == null) continue;
                return new EmptyAttrItemIter(template, entryClass);
            }
            int n2 = objectArray2.length;
            while (--n2 >= 0) {
                if (objectArray2[n2] == null) continue;
                return new AttrItemIter(template, n, n2);
            }
        }
        return new ClassItemIter(template);
    }

    public void modifyAttributes(ServiceID serviceID, long l, EntryRep[] entryRepArray, EntryRep[] entryRepArray2) throws UnknownLeaseException {
        if (serviceID.equals(this.myServiceID)) {
            throw new SecurityException("privileged service id");
        }
        this.concurrentObj.writeLock();
        try {
            this.modifyAttributesDo(serviceID, l, entryRepArray, entryRepArray2);
            this.addLogRecord(new AttrsModifiedLogObj(serviceID, l, entryRepArray, entryRepArray2));
        }
        finally {
            Object var7_5 = null;
            this.concurrentObj.writeUnlock();
        }
    }

    private void modifyAttributesDo(ServiceID serviceID, long l, EntryRep[] entryRepArray, EntryRep[] entryRepArray2) throws UnknownLeaseException {
        EntryRep entryRep;
        this.resolver.resolve(entryRepArray);
        this.resolver.resolveWithNulls(entryRepArray2);
        if (entryRepArray.length != entryRepArray2.length) {
            throw new IllegalArgumentException("attribute set length mismatch");
        }
        int n = entryRepArray2.length;
        while (--n >= 0) {
            if (entryRepArray2[n] == null || entryRepArray2[n].eclass.isAssignableFrom(entryRepArray[n].eclass)) continue;
            throw new IllegalArgumentException("attribute set type mismatch");
        }
        long l2 = System.currentTimeMillis();
        SvcReg svcReg = (SvcReg)this.serviceByID.get(serviceID);
        if (svcReg == null || svcReg.leaseID != l || svcReg.leaseExpiration <= l2) {
            throw new UnknownLeaseException();
        }
        Item item = (Item)svcReg.item.clone();
        EntryRep[] entryRepArray3 = item.attributeSets;
        Object[] objectArray = svcReg.item.attributeSets;
        int n2 = entryRepArray3.length;
        block1: while (--n2 >= 0) {
            EntryRep entryRep2 = entryRepArray3[n2];
            entryRep = objectArray[n2];
            int n3 = entryRepArray.length;
            while (--n3 >= 0) {
                if (!RegistrarImpl.matchEntry(entryRepArray[n3], entryRep2)) continue;
                EntryRep entryRep3 = entryRepArray2[n3];
                if (entryRep3 == null) {
                    objectArray = RegistrarImpl.deleteSet(svcReg.item, n2);
                    this.deleteAttrs(svcReg, entryRep, true);
                    continue block1;
                }
                this.updateAttrs(svcReg, entryRep, entryRep3.fields);
            }
        }
        int n4 = objectArray.length;
        while (--n4 >= 0) {
            entryRep = objectArray[n4];
            if (RegistrarImpl.indexOf(objectArray, n4, entryRep) < 0) continue;
            objectArray = RegistrarImpl.deleteSet(svcReg.item, n4);
            this.deleteInstance(entryRep.eclass);
        }
        svcReg.item.attributeSets = objectArray;
        this.generateEvents(item, svcReg.item, l2);
        this.queueEvents();
    }

    public void modifyLookupAttributes(Entry[] entryArray, Entry[] entryArray2) throws RemoteException {
        this.concurrentObj.writeLock();
        try {
            this.joiner.modifyAttributes(entryArray, entryArray2, true);
            this.lookupAttrs = this.joiner.getAttributes();
            EntryRep[] entryRepArray = EntryRep.toEntryRep(entryArray, false);
            EntryRep[] entryRepArray2 = EntryRep.toEntryRep(entryArray2, false);
            try {
                this.modifyAttributesDo(this.myServiceID, 0L, entryRepArray, entryRepArray2);
            }
            catch (UnknownLeaseException unknownLeaseException) {}
            this.addLogRecord(new AttrsModifiedLogObj(this.myServiceID, 0L, entryRepArray, entryRepArray2));
        }
        finally {
            Object var4_5 = null;
            this.concurrentObj.writeUnlock();
        }
    }

    private long newLeaseID() {
        this.secRand.nextBytes(this.secRandBuf8);
        long l = 0L;
        int n = 8;
        while (--n >= 0) {
            l = (l << 8) + (long)(this.secRandBuf8[n] & 0xFF);
        }
        return l;
    }

    private ServiceID newServiceID() {
        this.secRand.nextBytes(this.secRandBuf16);
        this.secRandBuf16[6] = (byte)(this.secRandBuf16[6] & 0xF);
        this.secRandBuf16[6] = (byte)(this.secRandBuf16[6] | 0x40);
        this.secRandBuf16[8] = (byte)(this.secRandBuf16[8] & 0x3F);
        this.secRandBuf16[8] = (byte)(this.secRandBuf16[8] | 0x80);
        this.secRandBuf16[10] = (byte)(this.secRandBuf16[10] | 0x80);
        long l = 0L;
        int n = 0;
        while (n < 8) {
            l = l << 8 | (long)(this.secRandBuf16[n] & 0xFF);
            ++n;
        }
        long l2 = 0L;
        int n2 = 8;
        while (n2 < 16) {
            l2 = l2 << 8 | (long)(this.secRandBuf16[n2] & 0xFF);
            ++n2;
        }
        return new ServiceID(l, l2);
    }

    public EventRegistration notify(Template template, int n, RemoteEventListener remoteEventListener, MarshalledObject marshalledObject, long l) {
        this.concurrentObj.writeLock();
        try {
            EventRegistration eventRegistration = this.notifyDo(template, n, remoteEventListener, marshalledObject, l);
            Object var9_7 = null;
            this.concurrentObj.writeUnlock();
            return eventRegistration;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
    }

    private EventRegistration notifyDo(Template template, int n, RemoteEventListener remoteEventListener, MarshalledObject marshalledObject, long l) {
        this.resolver.resolve(template);
        if (n == 0 || n != (n & 7)) {
            throw new IllegalArgumentException("invalid transitions");
        }
        if (remoteEventListener == null) {
            throw new NullPointerException("listener");
        }
        l = RegistrarImpl.limitDuration(l, this.maxEventLease);
        long l2 = System.currentTimeMillis();
        EventReg eventReg = new EventReg(this.eventID, this.newLeaseID(), template, n, remoteEventListener, marshalledObject, l2 + l);
        ++this.eventID;
        this.addEvent(eventReg);
        this.addLogRecord(new EventRegisteredLogObj(eventReg));
        if (eventReg.leaseExpiration < this.minEventExpiration) {
            this.minEventExpiration = eventReg.leaseExpiration;
            this.concurrentObj.waiterNotify(this.eventNotifier);
        }
        return new EventRegistration(eventReg.eventID, this.proxy, new EventLease(this, eventReg.eventID, eventReg.leaseID, eventReg.leaseExpiration), eventReg.seqNo);
    }

    private static boolean overlap(Object[] objectArray, Object[] objectArray2) {
        int n = objectArray.length;
        while (--n >= 0) {
            if (RegistrarImpl.indexOf(objectArray2, objectArray[n]) < 0) continue;
            return true;
        }
        return false;
    }

    private void pendingEvent(EventReg eventReg, ServiceID serviceID, Item item, int n) {
        if (item != null) {
            item = RegistrarImpl.copyItem(item);
        }
        this.newNotifies.add(new EventTask(eventReg, serviceID, item, n));
    }

    private String pickCodebase(EntryClass entryClass, long l) throws ClassNotFoundException {
        if (entryClass.getNumFields() == 0) {
            return this.pickCodebase(entryClass, (ArrayList)this.serviceByEmptyAttr.get(entryClass), l);
        }
        int n = entryClass.getNumFields() - 1;
        HashMap[] hashMapArray = (HashMap[])this.serviceByAttr.get(RegistrarImpl.getDefiningClass(entryClass, n));
        Iterator iterator = hashMapArray[n].values().iterator();
        while (iterator.hasNext()) {
            try {
                return this.pickCodebase(entryClass, (ArrayList)iterator.next(), l);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        throw new ClassNotFoundException();
    }

    private String pickCodebase(EntryClass entryClass, ArrayList arrayList, long l) throws ClassNotFoundException {
        int n = arrayList.size();
        while (--n >= 0) {
            SvcReg svcReg = (SvcReg)arrayList.get(n);
            if (svcReg.leaseExpiration <= l) continue;
            EntryRep[] entryRepArray = svcReg.item.attributeSets;
            int n2 = entryRepArray.length;
            while (--n2 >= 0) {
                if (!entryClass.equals(entryRepArray[n2].eclass)) continue;
                return entryRepArray[n2].codebase;
            }
        }
        throw new ClassNotFoundException();
    }

    private String pickCodebase(ServiceType serviceType, long l) throws ClassNotFoundException {
        ArrayList arrayList = (ArrayList)this.serviceByType.get(serviceType);
        int n = arrayList.size();
        while (--n >= 0) {
            SvcReg svcReg = (SvcReg)arrayList.get(n);
            if (svcReg.leaseExpiration <= l) continue;
            return svcReg.item.codebase;
        }
        throw new ClassNotFoundException();
    }

    private void queueEvents() {
        if (!this.newNotifies.isEmpty()) {
            this.tasker.addAll(this.newNotifies);
            this.newNotifies.clear();
        }
    }

    private void recoverSnapshot(InputStream inputStream) throws IOException, ClassNotFoundException {
        EventReg eventReg;
        SvcReg svcReg;
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        if (!(class$com$sun$jini$reggie$RegistrarImpl != null ? class$com$sun$jini$reggie$RegistrarImpl : (class$com$sun$jini$reggie$RegistrarImpl = RegistrarImpl.class$("com.sun.jini.reggie.RegistrarImpl"))).getName().equals(objectInputStream.readUTF())) {
            throw new IOException("log from wrong implementation");
        }
        if (objectInputStream.readInt() != 1) {
            throw new IOException("wrong log format version");
        }
        this.myServiceID = (ServiceID)objectInputStream.readObject();
        this.eventID = objectInputStream.readLong();
        this.logToSnapshotThresh = objectInputStream.readInt();
        this.snapshotWt = objectInputStream.readFloat();
        this.minMaxServiceLease = objectInputStream.readLong();
        this.minMaxEventLease = objectInputStream.readLong();
        this.minRenewalInterval = objectInputStream.readLong();
        this.unicastPort = objectInputStream.readInt();
        this.memberGroups = (String[])objectInputStream.readObject();
        this.lookupGroups = (String[])objectInputStream.readObject();
        this.lookupLocators = (LookupLocator[])objectInputStream.readObject();
        while ((svcReg = (SvcReg)objectInputStream.readObject()) != null) {
            this.resolver.resolve(svcReg.item);
            this.addService(svcReg);
        }
        while ((eventReg = (EventReg)objectInputStream.readObject()) != null) {
            this.resolver.resolve(eventReg.tmpl);
            eventReg.seqNo += Integer.MAX_VALUE;
            this.addEvent(eventReg);
        }
    }

    public ServiceRegistration register(Item item, long l) {
        this.concurrentObj.writeLock();
        try {
            ServiceRegistration serviceRegistration = this.registerDo(item, l);
            Object var6_4 = null;
            this.concurrentObj.writeUnlock();
            return serviceRegistration;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
    }

    private ServiceRegistration registerDo(Item item, long l) {
        Serializable serializable;
        this.resolver.resolve(item);
        if (item.service == null) {
            throw new NullPointerException("null service");
        }
        if (this.myServiceID.equals(item.serviceID)) {
            throw new IllegalArgumentException("reserved service id");
        }
        item.attributeSets = item.attributeSets == null ? emptyAttrs : (EntryRep[])RegistrarImpl.removeDups(item.attributeSets);
        l = RegistrarImpl.limitDuration(l, this.maxServiceLease);
        long l2 = System.currentTimeMillis();
        if (item.serviceID == null) {
            serializable = (ArrayList)this.serviceByType.get(item.serviceType);
            if (serializable != null) {
                int n = ((ArrayList)serializable).size();
                while (--n >= 0) {
                    SvcReg svcReg = (SvcReg)((ArrayList)serializable).get(n);
                    if (!item.service.equals(svcReg.item.service)) continue;
                    item.serviceID = svcReg.item.serviceID;
                    this.deleteService(svcReg, l2);
                    break;
                }
            }
            if (item.serviceID == null) {
                item.serviceID = this.newServiceID();
            }
        } else {
            serializable = (SvcReg)this.serviceByID.get(item.serviceID);
            if (serializable != null) {
                this.deleteService((SvcReg)serializable, l2);
            }
        }
        serializable = new SvcReg(item, this.newLeaseID(), l2 + l);
        this.addService((SvcReg)serializable);
        this.generateEvents(null, item, l2);
        this.addLogRecord(new SvcRegisteredLogObj((SvcReg)serializable));
        this.queueEvents();
        if (((SvcReg)serializable).leaseExpiration < this.minSvcExpiration) {
            this.minSvcExpiration = ((SvcReg)serializable).leaseExpiration;
            this.concurrentObj.waiterNotify(this.serviceNotifier);
        }
        return new Registration(this, new ServiceLease(this, item.serviceID, ((SvcReg)serializable).leaseID, ((SvcReg)serializable).leaseExpiration));
    }

    private static Object[] removeDups(Object[] objectArray) {
        int n = objectArray.length;
        while (--n >= 0) {
            if (RegistrarImpl.indexOf(objectArray, n, objectArray[n]) < 0) continue;
            objectArray = RegistrarImpl.arrayDel(objectArray, n);
        }
        return objectArray;
    }

    public void removeLookupGroups(String[] stringArray) throws RemoteException {
        this.concurrentObj.writeLock();
        try {
            this.discoer.removeGroups(stringArray);
            this.lookupGroups = this.discoer.getGroups();
            this.addLogRecord(new LookupGroupsChangedLogObj(this.lookupGroups));
        }
        finally {
            Object var3_2 = null;
            this.concurrentObj.writeUnlock();
        }
    }

    public void removeLookupLocators(LookupLocator[] lookupLocatorArray) throws RemoteException {
        this.concurrentObj.writeLock();
        try {
            this.discoer.removeLocators(lookupLocatorArray);
            this.lookupLocators = this.discoer.getLocators();
            this.addLogRecord(new LookupLocatorsChangedLogObj(this.lookupLocators));
        }
        finally {
            Object var3_2 = null;
            this.concurrentObj.writeUnlock();
        }
    }

    public void removeMemberGroups(String[] stringArray) throws RemoteException {
        this.concurrentObj.writeLock();
        try {
            int n = 0;
            while (n < stringArray.length) {
                int n2 = RegistrarImpl.indexOf(this.memberGroups, stringArray[n]);
                if (n2 >= 0) {
                    this.memberGroups = (String[])RegistrarImpl.arrayDel(this.memberGroups, n2);
                }
                ++n;
            }
            Thread thread = this.announcer;
            synchronized (thread) {
                this.announcer.notify();
            }
            this.addLogRecord(new MemberGroupsChangedLogObj(this.memberGroups));
        }
        finally {
            Object var3_5 = null;
            this.concurrentObj.writeUnlock();
        }
    }

    public long renewEventLease(long l, long l2, long l3) throws UnknownLeaseException {
        this.concurrentObj.writeLock();
        try {
            long l4 = this.renewEventLeaseDo(l, l2, l3);
            Object var10_5 = null;
            this.concurrentObj.writeUnlock();
            return l4;
        }
        catch (Throwable throwable) {
            Object var10_6 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
    }

    private void renewEventLeaseAbs(long l, long l2, long l3) {
        EventReg eventReg = (EventReg)this.eventByID.get(new Long(l));
        if (eventReg == null || eventReg.leaseID != l2) {
            return;
        }
        this.eventByTime.remove(eventReg);
        eventReg.leaseExpiration = l3;
        this.eventByTime.put(eventReg, eventReg);
    }

    private long renewEventLeaseDo(long l, long l2, long l3) throws UnknownLeaseException {
        long l4 = System.currentTimeMillis();
        long l5 = this.renewEventLeaseInt(l, l2, l3, l4);
        this.addLogRecord(new EventLeaseRenewedLogObj(l, l2, l5));
        return l5 - l4;
    }

    private long renewEventLeaseInt(long l, long l2, long l3, long l4) throws UnknownLeaseException {
        if (l3 == -1L) {
            l3 = this.maxEventLease;
        } else if (l3 < 0L) {
            throw new IllegalArgumentException("negative lease duration");
        }
        EventReg eventReg = (EventReg)this.eventByID.get(new Long(l));
        if (eventReg == null || eventReg.leaseID != l2 || eventReg.leaseExpiration <= l4) {
            throw new UnknownLeaseException();
        }
        if (l3 > this.maxEventLease && l3 > eventReg.leaseExpiration - l4) {
            l3 = Math.max(eventReg.leaseExpiration - l4, this.maxEventLease);
        }
        long l5 = l4 + l3;
        this.eventByTime.remove(eventReg);
        eventReg.leaseExpiration = l5;
        this.eventByTime.put(eventReg, eventReg);
        if (l5 < this.minEventExpiration) {
            this.minEventExpiration = l5;
            this.concurrentObj.waiterNotify(this.eventNotifier);
        }
        return l5;
    }

    public RenewResults renewLeases(Object[] objectArray, long[] lArray, long[] lArray2) {
        this.concurrentObj.writeLock();
        try {
            RenewResults renewResults = this.renewLeasesDo(objectArray, lArray, lArray2);
            Object var6_5 = null;
            this.concurrentObj.writeUnlock();
            return renewResults;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
    }

    private void renewLeasesAbs(Object[] objectArray, long[] lArray, long[] lArray2) {
        int n = objectArray.length;
        while (--n >= 0) {
            long l = lArray2[n];
            if (l < 0L) continue;
            Object object = objectArray[n];
            if (object instanceof ServiceID) {
                this.renewServiceLeaseAbs((ServiceID)object, lArray[n], l);
                continue;
            }
            this.renewEventLeaseAbs((Long)object, lArray[n], l);
        }
    }

    private RenewResults renewLeasesDo(Object[] objectArray, long[] lArray, long[] lArray2) {
        long l = System.currentTimeMillis();
        Exception[] exceptionArray = null;
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            try {
                lArray2[n] = object instanceof ServiceID ? this.renewServiceLeaseInt((ServiceID)object, lArray[n], lArray2[n], l) : this.renewEventLeaseInt((Long)object, lArray[n], lArray2[n], l);
            }
            catch (Exception exception) {
                lArray2[n] = -1L;
                exceptionArray = exceptionArray == null ? new Exception[]{exception} : (Exception[])RegistrarImpl.arrayAdd(exceptionArray, exception);
            }
            ++n;
        }
        this.addLogRecord(new LeasesRenewedLogObj(objectArray, lArray, lArray2));
        int n2 = objectArray.length;
        while (--n2 >= 0) {
            if (lArray2[n2] < 0L) continue;
            int n3 = n2;
            lArray2[n3] = lArray2[n3] - l;
        }
        return new RenewResults(lArray2, exceptionArray);
    }

    public long renewServiceLease(ServiceID serviceID, long l, long l2) throws UnknownLeaseException {
        this.concurrentObj.writeLock();
        try {
            long l3 = this.renewServiceLeaseDo(serviceID, l, l2);
            Object var9_5 = null;
            this.concurrentObj.writeUnlock();
            return l3;
        }
        catch (Throwable throwable) {
            Object var9_6 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
    }

    private void renewServiceLeaseAbs(ServiceID serviceID, long l, long l2) {
        SvcReg svcReg = (SvcReg)this.serviceByID.get(serviceID);
        if (svcReg == null || svcReg.leaseID != l) {
            return;
        }
        this.serviceByTime.remove(svcReg);
        svcReg.leaseExpiration = l2;
        this.serviceByTime.put(svcReg, svcReg);
    }

    private long renewServiceLeaseDo(ServiceID serviceID, long l, long l2) throws UnknownLeaseException {
        long l3 = System.currentTimeMillis();
        long l4 = this.renewServiceLeaseInt(serviceID, l, l2, l3);
        this.addLogRecord(new ServiceLeaseRenewedLogObj(serviceID, l, l4));
        return l4 - l3;
    }

    private long renewServiceLeaseInt(ServiceID serviceID, long l, long l2, long l3) throws UnknownLeaseException {
        if (serviceID.equals(this.myServiceID)) {
            throw new SecurityException("privileged service id");
        }
        if (l2 == -1L) {
            l2 = this.maxServiceLease;
        } else if (l2 < 0L) {
            throw new IllegalArgumentException("negative lease duration");
        }
        SvcReg svcReg = (SvcReg)this.serviceByID.get(serviceID);
        if (svcReg == null || svcReg.leaseID != l || svcReg.leaseExpiration <= l3) {
            throw new UnknownLeaseException();
        }
        if (l2 > this.maxServiceLease && l2 > svcReg.leaseExpiration - l3) {
            l2 = Math.max(svcReg.leaseExpiration - l3, this.maxServiceLease);
        }
        long l4 = l3 + l2;
        this.serviceByTime.remove(svcReg);
        svcReg.leaseExpiration = l4;
        this.serviceByTime.put(svcReg, svcReg);
        if (l4 < this.minSvcExpiration) {
            this.minSvcExpiration = l4;
            this.concurrentObj.waiterNotify(this.serviceNotifier);
        }
        return l4;
    }

    private void respond(Socket socket) {
        try {
            try {
                socket.setSoTimeout(this.unicastTimeout);
                IncomingUnicastRequest incomingUnicastRequest = new IncomingUnicastRequest(socket.getInputStream());
                OutgoingUnicastResponse.marshal(socket.getOutputStream(), this.proxy, this.memberGroups);
            }
            finally {
                Object var3_3 = null;
                socket.close();
            }
        }
        catch (IOException iOException) {}
    }

    public void setAttributes(ServiceID serviceID, long l, EntryRep[] entryRepArray) throws UnknownLeaseException {
        if (serviceID.equals(this.myServiceID)) {
            throw new SecurityException("privileged service id");
        }
        this.concurrentObj.writeLock();
        try {
            this.setAttributesDo(serviceID, l, entryRepArray);
            this.addLogRecord(new AttrsSetLogObj(serviceID, l, entryRepArray));
        }
        finally {
            Object var6_4 = null;
            this.concurrentObj.writeUnlock();
        }
    }

    private void setAttributesDo(ServiceID serviceID, long l, EntryRep[] entryRepArray) throws UnknownLeaseException {
        this.resolver.resolve(entryRepArray);
        entryRepArray = entryRepArray == null ? emptyAttrs : (EntryRep[])RegistrarImpl.removeDups(entryRepArray);
        long l2 = System.currentTimeMillis();
        SvcReg svcReg = (SvcReg)this.serviceByID.get(serviceID);
        if (svcReg == null || svcReg.leaseID != l || svcReg.leaseExpiration <= l2) {
            throw new UnknownLeaseException();
        }
        Item item = (Item)svcReg.item.clone();
        EntryRep[] entryRepArray2 = svcReg.item.attributeSets;
        int n = entryRepArray2.length;
        while (--n >= 0) {
            this.deleteAttrs(svcReg, entryRepArray2[n], false);
        }
        svcReg.item.attributeSets = entryRepArray;
        int n2 = entryRepArray.length;
        while (--n2 >= 0) {
            this.addAttrs(svcReg, entryRepArray[n2]);
        }
        this.generateEvents(item, svcReg.item, l2);
        this.queueEvents();
    }

    private static void setInterface(MulticastSocket multicastSocket) throws IOException {
        String string = System.getProperty("net.jini.discovery.interface");
        if (string != null) {
            multicastSocket.setInterface(InetAddress.getByName(string));
        }
    }

    public void setLogToSnapshotThreshold(int n) throws RemoteException {
        this.concurrentObj.writeLock();
        try {
            this.logToSnapshotThresh = n;
            this.addLogRecord(new LogToSnapshotThresholdSetLogObj(n));
        }
        finally {
            Object var3_2 = null;
            this.concurrentObj.writeUnlock();
        }
    }

    public void setLookupGroups(String[] stringArray) throws RemoteException {
        this.concurrentObj.writeLock();
        try {
            try {
                this.discoer.setGroups(stringArray);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.toString());
            }
            this.lookupGroups = this.discoer.getGroups();
            this.addLogRecord(new LookupGroupsChangedLogObj(this.lookupGroups));
        }
        finally {
            Object var3_3 = null;
            this.concurrentObj.writeUnlock();
        }
    }

    public void setLookupLocators(LookupLocator[] lookupLocatorArray) throws RemoteException {
        this.concurrentObj.writeLock();
        try {
            this.discoer.setLocators(lookupLocatorArray);
            this.lookupLocators = this.discoer.getLocators();
            this.addLogRecord(new LookupLocatorsChangedLogObj(this.lookupLocators));
        }
        finally {
            Object var3_2 = null;
            this.concurrentObj.writeUnlock();
        }
    }

    public void setMemberGroups(String[] stringArray) throws RemoteException {
        this.concurrentObj.writeLock();
        try {
            this.memberGroups = (String[])RegistrarImpl.removeDups(stringArray);
            this.addLogRecord(new MemberGroupsChangedLogObj(this.memberGroups));
            Thread thread = this.announcer;
            synchronized (thread) {
                this.announcer.notify();
            }
            Object var3_3 = null;
            this.concurrentObj.writeUnlock();
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
    }

    public void setMinMaxEventLease(long l) throws RemoteException {
        this.concurrentObj.writeLock();
        try {
            if (l > 31536000000000L) {
                throw new IllegalArgumentException("max duration exceeded");
            }
            this.minMaxEventLease = l;
            this.computeMaxLeases();
            this.addLogRecord(new MinMaxEventLeaseSetLogObj(l));
        }
        finally {
            Object var4_2 = null;
            this.concurrentObj.writeUnlock();
        }
    }

    public void setMinMaxServiceLease(long l) throws RemoteException {
        this.concurrentObj.writeLock();
        try {
            if (l > 31536000000000L) {
                throw new IllegalArgumentException("max duration exceeded");
            }
            this.minMaxServiceLease = l;
            this.computeMaxLeases();
            this.addLogRecord(new MinMaxServiceLeaseSetLogObj(l));
        }
        finally {
            Object var4_2 = null;
            this.concurrentObj.writeUnlock();
        }
    }

    public void setMinRenewalInterval(long l) throws RemoteException {
        this.concurrentObj.writeLock();
        try {
            if (l > 31536000000L) {
                throw new IllegalArgumentException("max interval exceeded");
            }
            this.minRenewalInterval = l;
            this.computeMaxLeases();
            this.addLogRecord(new MinRenewalIntervalSetLogObj(l));
        }
        finally {
            Object var4_2 = null;
            this.concurrentObj.writeUnlock();
        }
    }

    public void setSnapshotWeight(float f) throws RemoteException {
        this.concurrentObj.writeLock();
        try {
            this.snapshotWt = f;
            this.addLogRecord(new SnapshotWeightSetLogObj(f));
        }
        finally {
            Object var3_2 = null;
            this.concurrentObj.writeUnlock();
        }
    }

    public void setStorageLocation(String string) throws IOException, RemoteException {
        if (string.equals(this.logDirname)) {
            return;
        }
        this.concurrentObj.writeLock();
        try {
            ReliableLog reliableLog = new ReliableLog(string, new LocalLogHandler());
            reliableLog.snapshot();
            ReliableLog reliableLog2 = this.log;
            this.log = reliableLog;
            this.logDirname = string;
            if (this.activationID != null) {
                try {
                    ActivationSystem activationSystem = ActivationGroup.getSystem();
                    ActivationDesc activationDesc = activationSystem.getActivationDesc(this.activationID);
                    activationDesc = new ActivationDesc(activationDesc.getGroupID(), activationDesc.getClassName(), activationDesc.getLocation(), new MarshalledObject<String>(string), activationDesc.getRestartMode());
                    activationSystem.setActivationDesc(this.activationID, activationDesc);
                }
                catch (ActivationException activationException) {
                    throw new LogException("activation system problem", activationException);
                }
            }
            reliableLog2.deletePersistentStore();
        }
        finally {
            Object var3_7 = null;
            this.concurrentObj.writeUnlock();
        }
    }

    public void setUnicastPort(int n) throws IOException, RemoteException {
        if (n == this.unicastPort) {
            return;
        }
        this.concurrentObj.writeLock();
        try {
            if (n == 0 && this.unicaster.port == 4160 || n == this.unicaster.port) {
                this.unicastPort = n;
                this.addLogRecord(new UnicastPortSetLogObj(n));
                Object var3_2 = null;
                this.concurrentObj.writeUnlock();
                return;
            }
            UnicastThread unicastThread = new UnicastThread(n);
            this.unicaster.interrupt();
            try {
                this.unicaster.join();
            }
            catch (InterruptedException interruptedException) {}
            this.unicaster = unicastThread;
            this.unicaster.start();
            this.unicastPort = n;
            this.myLocator = new LookupLocator(this.myLocator.getHost(), this.unicaster.port);
            Thread thread = this.announcer;
            synchronized (thread) {
                this.announcer.notify();
            }
            this.addLogRecord(new UnicastPortSetLogObj(n));
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
        Object var3_3 = null;
        this.concurrentObj.writeUnlock();
    }

    private void takeSnapshot(OutputStream outputStream) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeUTF((class$com$sun$jini$reggie$RegistrarImpl != null ? class$com$sun$jini$reggie$RegistrarImpl : (class$com$sun$jini$reggie$RegistrarImpl = RegistrarImpl.class$("com.sun.jini.reggie.RegistrarImpl"))).getName());
        objectOutputStream.writeInt(1);
        objectOutputStream.writeObject(this.myServiceID);
        objectOutputStream.writeLong(this.eventID);
        objectOutputStream.writeInt(this.logToSnapshotThresh);
        objectOutputStream.writeFloat(this.snapshotWt);
        objectOutputStream.writeLong(this.minMaxServiceLease);
        objectOutputStream.writeLong(this.minMaxEventLease);
        objectOutputStream.writeLong(this.minRenewalInterval);
        objectOutputStream.writeInt(this.unicastPort);
        objectOutputStream.writeObject(this.memberGroups);
        objectOutputStream.writeObject(this.lookupGroups);
        objectOutputStream.writeObject(this.lookupLocators);
        Iterator iterator = this.serviceByID.values().iterator();
        while (iterator.hasNext()) {
            objectOutputStream.writeObject(iterator.next());
        }
        objectOutputStream.writeObject(null);
        Iterator iterator2 = this.eventByID.values().iterator();
        while (iterator2.hasNext()) {
            objectOutputStream.writeObject(iterator2.next());
        }
        objectOutputStream.writeObject(null);
        objectOutputStream.flush();
    }

    private void updateAttrs(SvcReg svcReg, EntryRep entryRep, Object[] objectArray) {
        EntryClass entryClass = entryRep.eclass;
        int n = objectArray.length;
        while (--n >= 0) {
            Object object = entryRep.fields[n];
            Object object2 = objectArray[n];
            if (object2 == null || object2.equals(object)) continue;
            entryClass = RegistrarImpl.getDefiningClass(entryClass, n);
            HashMap hashMap = this.addAttr(svcReg, entryClass, n, object2);
            entryRep.fields[n] = object2;
            if (RegistrarImpl.hasAttr(svcReg, entryClass, n, object)) continue;
            ArrayList arrayList = (ArrayList)hashMap.get(object);
            arrayList.remove(arrayList.indexOf(svcReg));
            if (!arrayList.isEmpty()) continue;
            hashMap.remove(object);
        }
    }

    private static final class SvcReg
    implements Comparable,
    Serializable {
        private static final long serialVersionUID = -1626838158255069853L;
        public final Item item;
        public final long leaseID;
        public long leaseExpiration;

        public SvcReg(Item item, long l, long l2) {
            this.item = item;
            this.leaseID = l;
            this.leaseExpiration = l2;
        }

        public int compareTo(Object object) {
            SvcReg svcReg = (SvcReg)object;
            if (this == svcReg) {
                return 0;
            }
            if (this.leaseExpiration < svcReg.leaseExpiration || this.leaseExpiration == svcReg.leaseExpiration && this.leaseID < svcReg.leaseID) {
                return -1;
            }
            return 1;
        }
    }

    private static final class EventReg
    implements Comparable,
    Serializable {
        private static final long serialVersionUID = -1549670962624946202L;
        public final long eventID;
        public final long leaseID;
        public final Template tmpl;
        public final int transitions;
        public long seqNo;
        public transient RemoteEventListener listener;
        public final MarshalledObject handback;
        public long leaseExpiration;

        public EventReg(long l, long l2, Template template, int n, RemoteEventListener remoteEventListener, MarshalledObject marshalledObject, long l3) {
            this.eventID = l;
            this.leaseID = l2;
            this.tmpl = template;
            this.transitions = n;
            this.seqNo = 0L;
            this.listener = remoteEventListener;
            this.handback = marshalledObject;
            this.leaseExpiration = l3;
        }

        public int compareTo(Object object) {
            EventReg eventReg = (EventReg)object;
            if (this == eventReg) {
                return 0;
            }
            if (this.leaseExpiration < eventReg.leaseExpiration || this.leaseExpiration == eventReg.leaseExpiration && this.eventID < eventReg.eventID) {
                return -1;
            }
            return 1;
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            block2: {
                objectInputStream.defaultReadObject();
                MarshalledObject marshalledObject = (MarshalledObject)objectInputStream.readObject();
                try {
                    this.listener = (RemoteEventListener)marshalledObject.get();
                }
                catch (Throwable throwable) {
                    if (!(throwable instanceof Error) || ThrowableConstants.retryable(throwable) != 2) break block2;
                    throw (Error)throwable;
                }
            }
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            objectOutputStream.writeObject(new MarshalledObject<RemoteEventListener>(this.listener));
        }
    }

    private static interface LogRecord
    extends Serializable {
        public void apply(RegistrarImpl var1);
    }

    private static class SvcRegisteredLogObj
    implements LogRecord {
        private static final long serialVersionUID = 833681392248560066L;
        private SvcReg reg;

        public SvcRegisteredLogObj(SvcReg svcReg) {
            this.reg = svcReg;
        }

        public void apply(RegistrarImpl registrarImpl) {
            registrarImpl.resolver.resolve(this.reg.item);
            registrarImpl.addService(this.reg);
        }
    }

    private static class AttrsAddedLogObj
    implements LogRecord {
        private static final long serialVersionUID = -5347182410011723905L;
        private ServiceID serviceID;
        private long leaseID;
        private EntryRep[] attrSets;

        public AttrsAddedLogObj(ServiceID serviceID, long l, EntryRep[] entryRepArray) {
            this.serviceID = serviceID;
            this.leaseID = l;
            this.attrSets = entryRepArray;
        }

        public void apply(RegistrarImpl registrarImpl) {
            try {
                registrarImpl.addAttributesDo(this.serviceID, this.leaseID, this.attrSets);
            }
            catch (UnknownLeaseException unknownLeaseException) {}
        }
    }

    private static class AttrsModifiedLogObj
    implements LogRecord {
        private static final long serialVersionUID = -2773350506956661576L;
        private ServiceID serviceID;
        private long leaseID;
        private EntryRep[] attrSetTmpls;
        private EntryRep[] attrSets;

        public AttrsModifiedLogObj(ServiceID serviceID, long l, EntryRep[] entryRepArray, EntryRep[] entryRepArray2) {
            this.serviceID = serviceID;
            this.leaseID = l;
            this.attrSetTmpls = entryRepArray;
            this.attrSets = entryRepArray2;
        }

        public void apply(RegistrarImpl registrarImpl) {
            try {
                registrarImpl.modifyAttributesDo(this.serviceID, this.leaseID, this.attrSetTmpls, this.attrSets);
            }
            catch (UnknownLeaseException unknownLeaseException) {}
        }
    }

    private static class AttrsSetLogObj
    implements LogRecord {
        private static final long serialVersionUID = -395979667535255420L;
        private ServiceID serviceID;
        private long leaseID;
        private EntryRep[] attrSets;

        public AttrsSetLogObj(ServiceID serviceID, long l, EntryRep[] entryRepArray) {
            this.serviceID = serviceID;
            this.leaseID = l;
            this.attrSets = entryRepArray;
        }

        public void apply(RegistrarImpl registrarImpl) {
            try {
                registrarImpl.setAttributesDo(this.serviceID, this.leaseID, this.attrSets);
            }
            catch (UnknownLeaseException unknownLeaseException) {}
        }
    }

    private static class EventRegisteredLogObj
    implements LogRecord {
        private static final long serialVersionUID = -807655888250060611L;
        private EventReg eventReg;

        public EventRegisteredLogObj(EventReg eventReg) {
            this.eventReg = eventReg;
        }

        public void apply(RegistrarImpl registrarImpl) {
            registrarImpl.resolver.resolve(this.eventReg.tmpl);
            this.eventReg.seqNo += Integer.MAX_VALUE;
            registrarImpl.addEvent(this.eventReg);
            RegistrarImpl registrarImpl2 = registrarImpl;
            registrarImpl2.eventID = registrarImpl2.eventID + 1L;
        }
    }

    private static class ServiceLeaseCancelledLogObj
    implements LogRecord {
        private static final long serialVersionUID = 8363406735506378972L;
        private ServiceID serviceID;
        private long leaseID;

        public ServiceLeaseCancelledLogObj(ServiceID serviceID, long l) {
            this.serviceID = serviceID;
            this.leaseID = l;
        }

        public void apply(RegistrarImpl registrarImpl) {
            try {
                registrarImpl.cancelServiceLeaseDo(this.serviceID, this.leaseID);
            }
            catch (UnknownLeaseException unknownLeaseException) {}
        }
    }

    private static class ServiceLeaseRenewedLogObj
    implements LogRecord {
        private static final long serialVersionUID = -6941618092365889931L;
        private ServiceID serviceID;
        private long leaseID;
        private long leaseExpTime;

        public ServiceLeaseRenewedLogObj(ServiceID serviceID, long l, long l2) {
            this.serviceID = serviceID;
            this.leaseID = l;
            this.leaseExpTime = l2;
        }

        public void apply(RegistrarImpl registrarImpl) {
            registrarImpl.renewServiceLeaseAbs(this.serviceID, this.leaseID, this.leaseExpTime);
        }
    }

    private static class EventLeaseCancelledLogObj
    implements LogRecord {
        private static final long serialVersionUID = 723479933309720973L;
        private long eventID;
        private long leaseID;

        public EventLeaseCancelledLogObj(long l, long l2) {
            this.eventID = l;
            this.leaseID = l2;
        }

        public void apply(RegistrarImpl registrarImpl) {
            try {
                registrarImpl.cancelEventLeaseDo(this.eventID, this.leaseID);
            }
            catch (UnknownLeaseException unknownLeaseException) {}
        }
    }

    private static class EventLeaseRenewedLogObj
    implements LogRecord {
        private static final long serialVersionUID = -2313983070714702699L;
        private long eventID;
        private long leaseID;
        private long leaseExpTime;

        public EventLeaseRenewedLogObj(long l, long l2, long l3) {
            this.eventID = l;
            this.leaseID = l2;
            this.leaseExpTime = l3;
        }

        public void apply(RegistrarImpl registrarImpl) {
            registrarImpl.renewEventLeaseAbs(this.eventID, this.leaseID, this.leaseExpTime);
        }
    }

    private static class LeasesRenewedLogObj
    implements LogRecord {
        private static final long serialVersionUID = -2796802215410373050L;
        private Object[] regIDs;
        private long[] leaseIDs;
        private long[] leaseExpTimes;

        public LeasesRenewedLogObj(Object[] objectArray, long[] lArray, long[] lArray2) {
            this.regIDs = objectArray;
            this.leaseIDs = lArray;
            this.leaseExpTimes = lArray2;
        }

        public void apply(RegistrarImpl registrarImpl) {
            registrarImpl.renewLeasesAbs(this.regIDs, this.leaseIDs, this.leaseExpTimes);
        }
    }

    private static class LeasesCancelledLogObj
    implements LogRecord {
        private static final long serialVersionUID = 7462419701214242565L;
        private Object[] regIDs;
        private long[] leaseIDs;

        public LeasesCancelledLogObj(Object[] objectArray, long[] lArray) {
            this.regIDs = objectArray;
            this.leaseIDs = lArray;
        }

        public void apply(RegistrarImpl registrarImpl) {
            registrarImpl.cancelLeasesDo(this.regIDs, this.leaseIDs);
        }
    }

    private static class UnicastPortSetLogObj
    implements LogRecord {
        private static final long serialVersionUID = -5923066193628958723L;
        private int newPort;

        public UnicastPortSetLogObj(int n) {
            this.newPort = n;
        }

        public void apply(RegistrarImpl registrarImpl) {
            registrarImpl.unicastPort = this.newPort;
        }
    }

    private static class MinMaxServiceLeaseSetLogObj
    implements LogRecord {
        private static final long serialVersionUID = 3205940543108355772L;
        private long newLeaseDuration;

        public MinMaxServiceLeaseSetLogObj(long l) {
            this.newLeaseDuration = l;
        }

        public void apply(RegistrarImpl registrarImpl) {
            registrarImpl.minMaxServiceLease = this.newLeaseDuration;
        }
    }

    private static class MinMaxEventLeaseSetLogObj
    implements LogRecord {
        private static final long serialVersionUID = -6425690586422726211L;
        private long newLeaseDuration;

        public MinMaxEventLeaseSetLogObj(long l) {
            this.newLeaseDuration = l;
        }

        public void apply(RegistrarImpl registrarImpl) {
            registrarImpl.minMaxEventLease = this.newLeaseDuration;
        }
    }

    private static class MinRenewalIntervalSetLogObj
    implements LogRecord {
        private static final long serialVersionUID = 5812923613520666861L;
        private long newRenewalInterval;

        public MinRenewalIntervalSetLogObj(long l) {
            this.newRenewalInterval = l;
        }

        public void apply(RegistrarImpl registrarImpl) {
            registrarImpl.minRenewalInterval = this.newRenewalInterval;
        }
    }

    private static class SnapshotWeightSetLogObj
    implements LogRecord {
        private static final long serialVersionUID = -7068462033891338457L;
        private float newWeight;

        public SnapshotWeightSetLogObj(float f) {
            this.newWeight = f;
        }

        public void apply(RegistrarImpl registrarImpl) {
            registrarImpl.snapshotWt = this.newWeight;
        }
    }

    private static class LookupGroupsChangedLogObj
    implements LogRecord {
        private static final long serialVersionUID = -5164130449456011085L;
        private String[] groups;

        public LookupGroupsChangedLogObj(String[] stringArray) {
            this.groups = stringArray;
        }

        public void apply(RegistrarImpl registrarImpl) {
            registrarImpl.lookupGroups = this.groups;
        }
    }

    private static class LookupLocatorsChangedLogObj
    implements LogRecord {
        private static final long serialVersionUID = 7707774807971026109L;
        private LookupLocator[] locators;

        public LookupLocatorsChangedLogObj(LookupLocator[] lookupLocatorArray) {
            this.locators = lookupLocatorArray;
        }

        public void apply(RegistrarImpl registrarImpl) {
            registrarImpl.lookupLocators = this.locators;
        }
    }

    private static class LogToSnapshotThresholdSetLogObj
    implements LogRecord {
        private static final long serialVersionUID = 7141538629320197819L;
        private int newThreshold;

        public LogToSnapshotThresholdSetLogObj(int n) {
            this.newThreshold = n;
        }

        public void apply(RegistrarImpl registrarImpl) {
            registrarImpl.logToSnapshotThresh = this.newThreshold;
        }
    }

    private static class MemberGroupsChangedLogObj
    implements LogRecord {
        private static final long serialVersionUID = 4764341386996269738L;
        private String[] groups;

        public MemberGroupsChangedLogObj(String[] stringArray) {
            this.groups = stringArray;
        }

        public void apply(RegistrarImpl registrarImpl) {
            registrarImpl.memberGroups = this.groups;
        }
    }

    private class LocalLogHandler
    extends LogHandler {
        public void applyUpdate(Object object) {
            ((LogRecord)object).apply(RegistrarImpl.this);
        }

        public void recover(InputStream inputStream) throws IOException, ClassNotFoundException {
            RegistrarImpl.this.recoverSnapshot(inputStream);
        }

        public void snapshot(OutputStream outputStream) throws IOException {
            RegistrarImpl.this.takeSnapshot(outputStream);
        }
    }

    private abstract class ItemIter {
        public final long now = System.currentTimeMillis();
        public boolean dupsPossible = false;
        protected final Template tmpl;
        protected SvcReg reg;

        protected ItemIter(Template template) {
            this.tmpl = template;
        }

        public boolean hasNext() {
            return this.reg != null;
        }

        public Item next() {
            if (this.reg == null) {
                throw new NoSuchElementException();
            }
            Item item = this.reg.item;
            this.step();
            return item;
        }

        public SvcReg nextReg() {
            if (this.reg == null) {
                throw new NoSuchElementException();
            }
            SvcReg svcReg = this.reg;
            this.step();
            return svcReg;
        }

        protected abstract void step();
    }

    private class AllItemIter
    extends ItemIter {
        private final Iterator iter;

        public AllItemIter() {
            super(null);
            this.iter = RegistrarImpl.this.serviceByID.values().iterator();
            this.step();
        }

        protected void step() {
            while (this.iter.hasNext()) {
                this.reg = (SvcReg)this.iter.next();
                if (this.reg.leaseExpiration <= this.now) continue;
                return;
            }
            this.reg = null;
        }
    }

    private class TypeItemIter
    extends ItemIter {
        private final ServiceType[] types;
        private int typeidx;
        private ArrayList svcs;
        private int svcidx = 0;

        public TypeItemIter(Template template) {
            super(template);
            this.types = RegistrarImpl.this.matchingConcreteClasses(template.serviceTypes);
            this.typeidx = this.types.length;
            this.step();
        }

        protected void step() {
            while (true) {
                if (--this.svcidx >= 0) {
                    this.reg = (SvcReg)this.svcs.get(this.svcidx);
                    if (this.reg.leaseExpiration <= this.now || !RegistrarImpl.matchAttributes(this.tmpl, this.reg.item)) continue;
                    return;
                }
                if (!this.stepType()) break;
            }
            this.reg = null;
        }

        private boolean stepType() {
            if (--this.typeidx < 0) {
                return false;
            }
            this.svcs = (ArrayList)RegistrarImpl.this.serviceByType.get(this.types[this.typeidx]);
            this.svcidx = this.svcs.size();
            return true;
        }
    }

    private class AttrItemIter
    extends ItemIter {
        protected ArrayList svcs;
        protected int svcidx;

        protected AttrItemIter(Template template) {
            super(template);
        }

        public AttrItemIter(Template template, int n, int n2) {
            super(template);
            EntryRep entryRep = template.attributeSetTemplates[n];
            HashMap[] hashMapArray = (HashMap[])RegistrarImpl.this.serviceByAttr.get(RegistrarImpl.getDefiningClass(entryRep.eclass, n2));
            if (hashMapArray != null && hashMapArray[n2] != null) {
                this.svcs = (ArrayList)hashMapArray[n2].get(entryRep.fields[n2]);
                if (this.svcs != null) {
                    this.svcidx = this.svcs.size();
                    this.step();
                }
            }
        }

        protected void step() {
            while (--this.svcidx >= 0) {
                this.reg = (SvcReg)this.svcs.get(this.svcidx);
                if (this.reg.leaseExpiration <= this.now || !RegistrarImpl.matchAttributes(this.tmpl, this.reg.item)) continue;
                return;
            }
            this.reg = null;
        }
    }

    private class EmptyAttrItemIter
    extends AttrItemIter {
        public EmptyAttrItemIter(Template template, EntryClass entryClass) {
            super(template);
            this.svcs = (ArrayList)RegistrarImpl.this.serviceByEmptyAttr.get(entryClass);
            if (this.svcs != null) {
                this.svcidx = this.svcs.size();
                this.step();
            }
        }
    }

    private class ClassItemIter
    extends ItemIter {
        private final EntryClass eclass;
        private int classidx;
        private Iterator iter;
        private ArrayList svcs;
        private int svcidx = 0;

        public ClassItemIter(Template template) {
            super(template);
            this.dupsPossible = true;
            this.eclass = template.attributeSetTemplates[0].eclass;
            this.classidx = RegistrarImpl.this.entryClasses.size();
            this.step();
        }

        protected void step() {
            while (true) {
                if (--this.svcidx >= 0) {
                    this.reg = (SvcReg)this.svcs.get(this.svcidx);
                    if (this.reg.leaseExpiration <= this.now || !RegistrarImpl.matchAttributes(this.tmpl, this.reg.item)) continue;
                    return;
                }
                if (!this.stepValue()) break;
            }
            this.reg = null;
        }

        private boolean stepClass() {
            while (--this.classidx >= 0) {
                EntryClass entryClass = (EntryClass)RegistrarImpl.this.entryClasses.get(this.classidx);
                if (!this.eclass.isAssignableFrom(entryClass)) continue;
                if (entryClass.getNumFields() > 0) {
                    entryClass = RegistrarImpl.getDefiningClass(entryClass, entryClass.getNumFields() - 1);
                    HashMap[] hashMapArray = (HashMap[])RegistrarImpl.this.serviceByAttr.get(entryClass);
                    this.iter = hashMapArray[hashMapArray.length - 1].values().iterator();
                } else {
                    this.iter = null;
                    this.svcs = (ArrayList)RegistrarImpl.this.serviceByEmptyAttr.get(entryClass);
                    this.svcidx = this.svcs.size();
                }
                return true;
            }
            return false;
        }

        private boolean stepValue() {
            do {
                if (this.iter != null && this.iter.hasNext()) {
                    this.svcs = (ArrayList)this.iter.next();
                    this.svcidx = this.svcs.size();
                    return true;
                }
                if (this.stepClass()) continue;
                return false;
            } while (this.iter != null);
            return true;
        }
    }

    private class IDItemIter
    extends ItemIter {
        public IDItemIter(Template template) {
            super(template);
            this.reg = (SvcReg)RegistrarImpl.this.serviceByID.get(template.serviceID);
            if (!(this.reg == null || this.reg.leaseExpiration > this.now && RegistrarImpl.matchItem(template, this.reg.item))) {
                this.reg = null;
            }
        }

        protected void step() {
            this.reg = null;
        }
    }

    private final class EventTask
    implements TaskManager.Task {
        public final EventReg reg;
        public final long seqNo;
        public final ServiceID sid;
        public final Item item;
        public final int transition;

        public EventTask(EventReg eventReg, ServiceID serviceID, Item item, int n) {
            this.reg = eventReg;
            this.seqNo = ++eventReg.seqNo;
            this.sid = serviceID;
            this.item = item;
            this.transition = n;
        }

        public void run() {
            try {
                this.reg.listener.notify(new RegistrarEvent(RegistrarImpl.this.proxy, this.reg.eventID, this.seqNo, this.reg.handback, this.sid, this.transition, this.item));
            }
            catch (Throwable throwable) {
                switch (ThrowableConstants.retryable(throwable)) {
                    case 2: {
                        if (throwable instanceof Error) {
                            throw (Error)throwable;
                        }
                    }
                    case 1: 
                    case 3: {
                        try {
                            RegistrarImpl.this.cancelEventLease(this.reg.eventID, this.reg.leaseID);
                        }
                        catch (UnknownLeaseException unknownLeaseException) {}
                        break;
                    }
                }
            }
        }

        public boolean runAfter(List list, int n) {
            int n2 = n;
            while (--n2 >= 0) {
                Object e = list.get(n2);
                if (!(e instanceof EventTask) || !this.reg.listener.equals(((EventTask)e).reg.listener)) continue;
                return true;
            }
            return false;
        }
    }

    private final class AddressTask
    implements TaskManager.Task {
        public final InetAddress addr;
        public final int port;

        public AddressTask(InetAddress inetAddress, int n) {
            this.addr = inetAddress;
            this.port = n;
        }

        public boolean equals(Object object) {
            if (!(object instanceof AddressTask)) {
                return false;
            }
            AddressTask addressTask = (AddressTask)object;
            return this.addr.equals(addressTask.addr) && this.port == addressTask.port;
        }

        public int hashCode() {
            return this.addr.hashCode();
        }

        public void run() {
            try {
                RegistrarImpl.this.respond(new Socket(this.addr, this.port));
            }
            catch (IOException iOException) {
            }
            catch (SecurityException securityException) {}
        }

        public boolean runAfter(List list, int n) {
            return false;
        }
    }

    private final class SocketTask
    implements TaskManager.Task {
        public final Socket socket;

        public SocketTask(Socket socket) {
            this.socket = socket;
        }

        public void run() {
            RegistrarImpl.this.respond(this.socket);
        }

        public boolean runAfter(List list, int n) {
            return false;
        }
    }

    private class ServiceExpireThread
    extends Thread {
        public ServiceExpireThread() {
            super("service expire");
            this.setDaemon(true);
        }

        public void run() {
            try {
                RegistrarImpl.this.concurrentObj.writeLock();
            }
            catch (ReadersWriter.ConcurrentLockException concurrentLockException) {
                return;
            }
            try {
                while (!this.isInterrupted()) {
                    long l = System.currentTimeMillis();
                    while (true) {
                        SvcReg svcReg = (SvcReg)RegistrarImpl.this.serviceByTime.firstKey();
                        RegistrarImpl.this.minSvcExpiration = svcReg.leaseExpiration;
                        if (RegistrarImpl.this.minSvcExpiration > l) break;
                        RegistrarImpl.this.deleteService(svcReg, l);
                    }
                    RegistrarImpl.this.queueEvents();
                    try {
                        RegistrarImpl.this.concurrentObj.writerWait(RegistrarImpl.this.serviceNotifier, RegistrarImpl.this.minSvcExpiration - l);
                    }
                    catch (ReadersWriter.ConcurrentLockException concurrentLockException) {
                        Object var2_3 = null;
                        RegistrarImpl.this.concurrentObj.writeUnlock();
                        return;
                    }
                }
            }
            finally {
                Object var2_4 = null;
                RegistrarImpl.this.concurrentObj.writeUnlock();
            }
        }
    }

    private class EventExpireThread
    extends Thread {
        public EventExpireThread() {
            super("event expire");
            this.setDaemon(true);
        }

        public void run() {
            try {
                RegistrarImpl.this.concurrentObj.writeLock();
            }
            catch (ReadersWriter.ConcurrentLockException concurrentLockException) {
                return;
            }
            try {
                while (!this.isInterrupted()) {
                    long l = System.currentTimeMillis();
                    RegistrarImpl.this.minEventExpiration = Long.MAX_VALUE;
                    while (!RegistrarImpl.this.eventByTime.isEmpty()) {
                        EventReg eventReg = (EventReg)RegistrarImpl.this.eventByTime.firstKey();
                        if (eventReg.leaseExpiration > l) {
                            RegistrarImpl.this.minEventExpiration = eventReg.leaseExpiration;
                            break;
                        }
                        RegistrarImpl.this.deleteEvent(eventReg);
                    }
                    try {
                        RegistrarImpl.this.concurrentObj.writerWait(RegistrarImpl.this.eventNotifier, RegistrarImpl.this.minEventExpiration - l);
                    }
                    catch (ReadersWriter.ConcurrentLockException concurrentLockException) {
                        Object var2_3 = null;
                        RegistrarImpl.this.concurrentObj.writeUnlock();
                        return;
                    }
                }
            }
            finally {
                Object var2_4 = null;
                RegistrarImpl.this.concurrentObj.writeUnlock();
            }
        }
    }

    private class DestroyThread
    extends Thread {
        public DestroyThread() {
            super("destroy");
            this.setDaemon(false);
        }

        public void run() {
            block18: {
                if (RegistrarImpl.this.activationID != null) {
                    try {
                        Activatable.unregister((ActivationID)RegistrarImpl.this.activationID);
                    }
                    catch (RemoteException remoteException) {
                        return;
                    }
                    catch (ActivationException activationException) {}
                }
                try {
                    while (!UnicastRemoteObject.unexportObject(RegistrarImpl.this, false)) {
                        Thread.yield();
                    }
                }
                catch (NoSuchObjectException noSuchObjectException) {}
                RegistrarImpl.this.serviceExpirer.interrupt();
                RegistrarImpl.this.eventExpirer.interrupt();
                RegistrarImpl.this.unicaster.interrupt();
                RegistrarImpl.this.multicaster.interrupt();
                RegistrarImpl.this.announcer.interrupt();
                RegistrarImpl.this.snapshotter.interrupt();
                RegistrarImpl.this.tasker.terminate();
                RegistrarImpl.this.joiner.terminate();
                RegistrarImpl.this.discoer.terminate();
                try {
                    RegistrarImpl.this.serviceExpirer.join();
                    RegistrarImpl.this.eventExpirer.join();
                    RegistrarImpl.this.unicaster.join();
                    RegistrarImpl.this.multicaster.join();
                    RegistrarImpl.this.announcer.join();
                    RegistrarImpl.this.snapshotter.join();
                }
                catch (InterruptedException interruptedException) {}
                RegistrarImpl.this.closeRequestSockets(RegistrarImpl.this.tasker.getPending());
                RegistrarImpl.this.log.deletePersistentStore();
                if (RegistrarImpl.this.activationID == null) break block18;
                ActivationGroupID activationGroupID = ActivationGroup.currentGroupID();
                try {
                    while (!Activatable.inactive((ActivationID)RegistrarImpl.this.activationID)) {
                        Thread.yield();
                    }
                }
                catch (RemoteException remoteException) {
                }
                catch (ActivationException activationException) {}
                try {
                    ActivationGroup.getSystem().unregisterGroup(activationGroupID);
                }
                catch (RemoteException remoteException) {
                }
                catch (ActivationException activationException) {}
            }
        }
    }

    private class MulticastThread
    extends Thread {
        private final MulticastSocket socket;
        private boolean interrupted = false;

        public MulticastThread() throws IOException {
            super("multicast request");
            this.setDaemon(true);
            this.setPriority(10);
            this.socket = new MulticastSocket(4160);
            this.socket.joinGroup(Constants.getRequestAddress());
            RegistrarImpl.setInterface(this.socket);
        }

        public void interrupt() {
            this.interrupted = true;
            this.socket.close();
        }

        public boolean isInterrupted() {
            return this.interrupted;
        }

        public void run() {
            byte[] byArray = new byte[576];
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
            while (!this.isInterrupted()) {
                try {
                    datagramPacket.setLength(byArray.length);
                    try {
                        this.socket.receive(datagramPacket);
                    }
                    catch (NullPointerException nullPointerException) {
                        break;
                    }
                    IncomingMulticastRequest incomingMulticastRequest = new IncomingMulticastRequest(datagramPacket);
                    if (incomingMulticastRequest.getGroups().length != 0 && !RegistrarImpl.overlap(RegistrarImpl.this.memberGroups, incomingMulticastRequest.getGroups()) || RegistrarImpl.indexOf(incomingMulticastRequest.getServiceIDs(), RegistrarImpl.this.myServiceID) >= 0) continue;
                    RegistrarImpl.this.tasker.addIfNew(new AddressTask(incomingMulticastRequest.getAddress(), incomingMulticastRequest.getPort()));
                }
                catch (InterruptedIOException interruptedIOException) {
                    break;
                }
                catch (IOException iOException) {
                }
                catch (SecurityException securityException) {}
            }
            this.socket.close();
        }
    }

    private class UnicastThread
    extends Thread {
        private ServerSocket listen;
        public int port;
        private boolean interrupted = false;

        public UnicastThread(int n) throws IOException {
            super("unicast request");
            this.setDaemon(true);
            if (n == 0) {
                try {
                    this.listen = new ServerSocket(4160);
                    this.port = 4160;
                    return;
                }
                catch (IOException iOException) {}
            }
            this.listen = new ServerSocket(n);
            this.port = this.listen.getLocalPort();
        }

        public void interrupt() {
            this.interrupted = true;
            try {
                new Socket(InetAddress.getLocalHost(), this.port).close();
            }
            catch (IOException iOException) {}
        }

        public boolean isInterrupted() {
            return this.interrupted;
        }

        public void run() {
            while (!this.isInterrupted()) {
                try {
                    Socket socket = this.listen.accept();
                    if (this.isInterrupted()) {
                        try {
                            socket.close();
                        }
                        catch (IOException iOException) {}
                        break;
                    }
                    RegistrarImpl.this.tasker.add(new SocketTask(socket));
                }
                catch (InterruptedIOException interruptedIOException) {
                    break;
                }
                catch (IOException iOException) {
                }
                catch (SecurityException securityException) {}
            }
            try {
                this.listen.close();
            }
            catch (IOException iOException) {}
        }
    }

    private class AnnounceThread
    extends Thread {
        private final MulticastSocket socket;

        public AnnounceThread() throws IOException {
            super("discovery announcement");
            this.setDaemon(true);
            this.socket = new MulticastSocket();
            this.socket.setTimeToLive(Integer.getInteger("net.jini.discovery.ttl", 15));
            RegistrarImpl.setInterface(this.socket);
        }

        private boolean announce(String[] stringArray) {
            try {
                DatagramPacket[] datagramPacketArray = OutgoingMulticastAnnouncement.marshal(RegistrarImpl.this.myServiceID, RegistrarImpl.this.myLocator, stringArray);
                int n = datagramPacketArray.length;
                while (--n >= 0) {
                    try {
                        this.socket.send(datagramPacketArray[n]);
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        return false;
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (InterruptedIOException interruptedIOException) {
                return false;
            }
            catch (IOException iOException) {}
            return true;
        }

        public synchronized void run() {
            int n = Integer.getInteger("net.jini.discovery.announce", 120000);
            try {
                while (!this.isInterrupted() && this.announce(RegistrarImpl.this.memberGroups)) {
                    this.wait(n);
                }
            }
            catch (InterruptedException interruptedException) {}
            if (RegistrarImpl.this.memberGroups.length > 0) {
                this.announce(new String[0]);
            }
            this.socket.close();
        }
    }

    private class SnapshotThread
    extends Thread {
        public SnapshotThread() {
            super("snapshot thread");
            this.setDaemon(true);
        }

        public void run() {
            block12: {
                try {
                    RegistrarImpl.this.concurrentObj.readLock();
                }
                catch (ReadersWriter.ConcurrentLockException concurrentLockException) {
                    return;
                }
                while (true) {
                    if (this.isInterrupted()) break block12;
                    try {
                        RegistrarImpl.this.concurrentObj.readerWait(RegistrarImpl.this.snapshotNotifier, Long.MAX_VALUE);
                        try {
                            RegistrarImpl.this.log.snapshot();
                            RegistrarImpl.this.logFileSize = 0;
                        }
                        catch (InterruptedIOException interruptedIOException) {
                            Object var2_2 = null;
                            RegistrarImpl.this.concurrentObj.readUnlock();
                            return;
                        }
                        catch (Exception exception) {
                            if (exception instanceof LogException && ((LogException)exception).detail instanceof InterruptedIOException) {
                                Object var2_3 = null;
                                RegistrarImpl.this.concurrentObj.readUnlock();
                                return;
                            }
                            exception.printStackTrace();
                        }
                    }
                    catch (ReadersWriter.ConcurrentLockException concurrentLockException) {
                        Object var2_4 = null;
                        RegistrarImpl.this.concurrentObj.readUnlock();
                        return;
                    }
                }
                finally {
                    Object var2_5 = null;
                    RegistrarImpl.this.concurrentObj.readUnlock();
                }
            }
        }
    }
}

