/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.reliableLog;

import com.sun.jini.reliableLog.LogException;
import java.io.IOException;
import java.io.InputStream;

public class LogInputStream
extends InputStream {
    private InputStream in;
    private int length;

    public LogInputStream(InputStream inputStream, int n) throws IOException {
        this.in = inputStream;
        this.length = n;
    }

    public int available() {
        return this.length;
    }

    private void badRead(int n) throws LogException {
        throw new LogException("length=" + String.valueOf(this.length) + ", numBytes=" + String.valueOf(n));
    }

    public void close() {
        this.length = 0;
    }

    protected void finalize() throws IOException {
        this.close();
    }

    public int read() throws IOException, LogException {
        if (this.length < 1) {
            this.badRead(1);
        }
        --this.length;
        return this.in.read();
    }

    public int read(byte[] byArray) throws IOException, LogException {
        if (this.length < byArray.length) {
            this.badRead(byArray.length);
        }
        int n = this.in.read(byArray);
        this.length -= n;
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException, LogException {
        if (this.length < n2) {
            this.badRead(n2);
        }
        n2 = this.in.read(byArray, n, n2);
        this.length -= n2;
        return n2;
    }

    public long skip(long l) throws IOException, LogException {
        if ((long)this.length < l) {
            this.badRead((int)l);
        }
        l = this.in.skip(l);
        this.length -= (int)l;
        return l;
    }
}

