/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.start;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.SecureClassLoader;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class ClassLoaderUtil {
    public static final int PARENT_DEFAULT = 0;
    public static final int PARENT_EXTENSION = -1;
    public static final int PARENT_SYSTEM_PARENT = -2;

    public static String URLsToString(URL[] uRLArray) {
        if (uRLArray == null || uRLArray.length == 0) {
            return new String("");
        }
        StringBuffer stringBuffer = new StringBuffer(uRLArray[0].toString());
        int n = 1;
        while (n < uRLArray.length) {
            stringBuffer.append(" " + uRLArray[n].toString());
            ++n;
        }
        return stringBuffer.toString();
    }

    public static void displayClassLoaderTree(ClassLoader classLoader) {
        ArrayList arrayList = ClassLoaderUtil.getClassLoaderTree(classLoader);
        System.out.println("");
        System.out.println("ClassLoader Tree has " + arrayList.size() + " levels");
        System.out.println("  cl0 -- boot ClassLoader");
        System.out.println("   |");
        System.out.println("  cl1 -- extension ClassLoader");
        int n = arrayList.size() - 2 - 1;
        int n2 = 2;
        while (n >= 0) {
            System.out.println("   |");
            ClassLoader classLoader2 = (ClassLoader)arrayList.get(n);
            System.out.print("  cl" + n2 + " -- ClassLoader " + classLoader2 + ": ");
            if (classLoader2 instanceof URLClassLoader) {
                URL[] uRLArray = ((URLClassLoader)classLoader2).getURLs();
                if (uRLArray != null) {
                    System.out.print(uRLArray[0]);
                    int n3 = 1;
                    while (n3 < uRLArray.length) {
                        System.out.print(", " + uRLArray[n3]);
                        ++n3;
                    }
                } else {
                    System.out.print("null search path");
                }
            } else if (classLoader2 instanceof SecureClassLoader) {
                System.out.print("is instance of SecureClassLoader");
            } else {
                System.out.print("is unknown ClassLoader type");
            }
            System.out.println("");
            --n;
            ++n2;
        }
        System.out.println("");
    }

    public static void displayCurClassLoaderTree() {
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        ClassLoaderUtil.displayClassLoaderTree(classLoader);
    }

    public static ArrayList getClassLoaderTree(ClassLoader classLoader) {
        ArrayList<ClassLoader> arrayList = new ArrayList<ClassLoader>();
        ClassLoader classLoader2 = classLoader;
        arrayList.add(classLoader2);
        ClassLoader classLoader3 = classLoader2.getParent();
        arrayList.add(classLoader3);
        while (classLoader3 != null) {
            classLoader3 = classLoader3.getParent();
            arrayList.add(classLoader3);
        }
        return arrayList;
    }

    public static URL[] getClasspathURLs(String string) throws MalformedURLException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        URL[] uRLArray = new URL[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            uRLArray[n] = new File(stringTokenizer.nextToken()).toURL();
            ++n;
        }
        return uRLArray;
    }

    public static URLClassLoader getCodebaseClassLoader(String string, String string2, int n) throws MalformedURLException {
        URL[] uRLArray = ClassLoaderUtil.getClasspathURLs(string);
        URL[] uRLArray2 = ClassLoaderUtil.getCodebaseURLs(string2);
        ArrayList arrayList = null;
        switch (n) {
            case 0: {
                return new CodebaseClassLoader(uRLArray, uRLArray2);
            }
            case -1: {
                arrayList = ClassLoaderUtil.getCurClassLoaderTree();
                int n2 = arrayList.size() - 2;
                ClassLoader classLoader = (ClassLoader)arrayList.get(n2);
                return new CodebaseClassLoader(uRLArray, classLoader, uRLArray2);
            }
            case -2: {
                ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                ClassLoader classLoader2 = classLoader.getParent();
                return new CodebaseClassLoader(uRLArray, classLoader2, uRLArray2);
            }
        }
        arrayList = ClassLoaderUtil.getCurClassLoaderTree();
        int n3 = 0;
        while (n3 < n) {
            arrayList.remove(0);
            ++n3;
        }
        ClassLoader classLoader = (ClassLoader)arrayList.get(0);
        return new CodebaseClassLoader(uRLArray, classLoader, uRLArray2);
    }

    public static URL[] getCodebaseURLs(String string) throws MalformedURLException {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        URL[] uRLArray = new URL[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            uRLArray[n] = new URL(stringTokenizer.nextToken());
            ++n;
        }
        return uRLArray;
    }

    public static ArrayList getCurClassLoaderTree() {
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        return ClassLoaderUtil.getClassLoaderTree(classLoader);
    }

    public static URLClassLoader getURLClassLoader(String string) throws MalformedURLException {
        return ClassLoaderUtil.getURLClassLoader(string, false, 0);
    }

    public static URLClassLoader getURLClassLoader(String string, boolean bl) throws MalformedURLException {
        return ClassLoaderUtil.getURLClassLoader(string, bl, 0);
    }

    public static URLClassLoader getURLClassLoader(String string, boolean bl, int n) throws MalformedURLException {
        URL[] uRLArray = bl ? ClassLoaderUtil.getClasspathURLs(string) : ClassLoaderUtil.getCodebaseURLs(string);
        ArrayList arrayList = null;
        switch (n) {
            case 0: {
                return new URLClassLoader(uRLArray);
            }
            case -1: {
                arrayList = ClassLoaderUtil.getCurClassLoaderTree();
                int n2 = arrayList.size() - 2;
                ClassLoader classLoader = (ClassLoader)arrayList.get(n2);
                return new URLClassLoader(uRLArray, classLoader);
            }
            case -2: {
                ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                ClassLoader classLoader2 = classLoader.getParent();
                return new URLClassLoader(uRLArray, classLoader2);
            }
        }
        arrayList = ClassLoaderUtil.getCurClassLoaderTree();
        int n3 = 0;
        while (n3 < n) {
            arrayList.remove(0);
            ++n3;
        }
        ClassLoader classLoader = (ClassLoader)arrayList.get(0);
        return new URLClassLoader(uRLArray, classLoader);
    }

    static class CodebaseClassLoader
    extends URLClassLoader {
        private URL[] codebase;

        CodebaseClassLoader(URL[] uRLArray, ClassLoader classLoader, URL[] uRLArray2) {
            super(uRLArray, classLoader);
            this.codebase = uRLArray2;
        }

        CodebaseClassLoader(URL[] uRLArray, URL[] uRLArray2) {
            super(uRLArray);
            this.codebase = uRLArray2;
        }

        public URL[] getURLs() {
            return this.codebase;
        }
    }
}

