/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.start;

import com.sun.jini.start.StartUtil;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class HTTPDStatus {
    public static final int DOWN = 0;
    public static final int UP = 1;
    public static final int UP_BUT_NO_JAR = 2;
    private static String defProtocol = "no_protocol";
    private static String defHost = HTTPDStatus.getLocalHost();
    private static int defPort = 80;
    private static String defJarFile = "no_jar_file";
    private static int timeout = 1000;

    private static void closeSocket(Socket socket) {
        if (socket == null) {
            return;
        }
        try {
            socket.close();
        }
        catch (IOException iOException) {
            System.err.println("\nOn closing socket -- " + iOException.toString());
            iOException.printStackTrace();
        }
    }

    private static void delay(int n) {
        if (n <= 0) {
            return;
        }
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {}
    }

    private static void displaySocketInfo(Socket socket) {
        if (socket == null) {
            return;
        }
        System.out.println("Socket Information -- ");
        System.out.println("  Destination:    host/address - " + socket.getInetAddress() + ", port - " + socket.getPort());
        System.out.println("  Source:         host/address - " + socket.getLocalAddress() + ", port - " + socket.getLocalPort());
        try {
            System.out.println("  Socket Timeout: " + socket.getSoTimeout());
            int n = socket.getSoLinger();
            if (n < 0) {
                System.out.println("  Socket Linger:  disabled");
            } else {
                System.out.println("  Socket Linger:  " + n);
            }
            boolean bl = socket.getTcpNoDelay();
            if (bl) {
                System.out.println("  Socket is using Nagle's algorithm");
            } else {
                System.out.println("  Socket is NOT using Nagle's algorithm");
            }
        }
        catch (SocketException socketException) {}
        System.out.println("\n");
    }

    private static void drainSocket(Socket socket) {
        if (socket == null) {
            return;
        }
        try {
            InputStream inputStream = socket.getInputStream();
            int n = inputStream.read();
            while (n >= 0) {
                n = inputStream.read();
            }
        }
        catch (InterruptedIOException interruptedIOException) {
        }
        catch (IOException iOException) {
            System.err.println("\nWhile draining the socket -- " + iOException.toString());
            iOException.printStackTrace();
        }
    }

    private static void drainSocket(Socket socket, int n) {
        if (socket == null || n <= 0) {
            return;
        }
        try {
            InputStream inputStream = socket.getInputStream();
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                try {
                    int n4 = inputStream.read();
                    if (n4 == -1) break;
                    ++n2;
                }
                catch (InterruptedIOException interruptedIOException) {
                    System.err.println("\nSocket read time out: " + n2 + " bytes read before timeout occurred");
                }
                ++n3;
            }
        }
        catch (IOException iOException) {
            System.err.println("\nWhile draining the socket -- " + iOException.toString());
            iOException.printStackTrace();
        }
    }

    private static String[] getHeader(Socket socket) {
        Object object;
        Object object2;
        if (socket == null) {
            return new String[0];
        }
        String string = null;
        try {
            int n;
            object2 = socket.getInputStream();
            object = new StringBuffer();
            while ((n = ((InputStream)object2).read()) >= 0) {
                ((StringBuffer)object).append((char)n);
                int n2 = ((StringBuffer)object).length();
                if (n2 <= 3 || ((StringBuffer)object).charAt(n2 - 4) != '\r' || ((StringBuffer)object).charAt(n2 - 3) != '\n' || ((StringBuffer)object).charAt(n2 - 2) != '\r' || ((StringBuffer)object).charAt(n2 - 1) != '\n') continue;
                string = ((StringBuffer)object).toString();
                break;
            }
        }
        catch (InterruptedIOException interruptedIOException) {
        }
        catch (IOException iOException) {
            System.err.println("\nWhile getting header -- " + iOException.toString());
            iOException.printStackTrace();
        }
        if (string == null) {
            return new String[0];
        }
        object2 = new ArrayList();
        object = new StringTokenizer(string, "\r\n");
        while (((StringTokenizer)object).hasMoreTokens()) {
            ((ArrayList)object2).add(((StringTokenizer)object).nextToken());
        }
        return ((ArrayList)object2).toArray(new String[((ArrayList)object2).size()]);
    }

    private static String getLocalHost() {
        String string = "localhost";
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            System.err.println("\nOn hostname retrieval -- " + unknownHostException.toString());
            unknownHostException.printStackTrace();
        }
        return string;
    }

    private static int getNBytesToRead(String[] stringArray) {
        int n = -1;
        if (stringArray == null || stringArray.length < 2) {
            return n;
        }
        if (stringArray[1].startsWith("Content-Length:")) {
            StringTokenizer stringTokenizer = new StringTokenizer(stringArray[1]);
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        return n;
    }

    private static String getURLFile(URL uRL) {
        String string = uRL.getFile();
        if (string.startsWith("/")) {
            return string.substring(1);
        }
        return string;
    }

    public static int httpdStatus(String string) {
        String string2 = defHost;
        int n = defPort;
        String string3 = defJarFile;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \"");
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            try {
                URL uRL = new URL(string4);
                string2 = uRL.getHost();
                int n3 = uRL.getPort();
                if (n3 != -1) {
                    n = n3;
                }
                string3 = HTTPDStatus.getURLFile(uRL);
            }
            catch (MalformedURLException malformedURLException) {
                try {
                    string2 = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException unknownHostException) {}
            }
            int n4 = HTTPDStatus.httpdStatus(string2, n, string3);
            if (n4 != 1) {
                return n4;
            }
            ++n2;
        }
        return 1;
    }

    public static int httpdStatus(String string, int n, String string2) {
        Socket socket = HTTPDStatus.openSocket(string, n);
        if (socket != null) {
            HTTPDStatus.writeGetToSocket(socket, string2);
            String[] stringArray = HTTPDStatus.getHeader(socket);
            boolean bl = HTTPDStatus.replyOK(stringArray);
            HTTPDStatus.drainSocket(socket);
            HTTPDStatus.closeSocket(socket);
            if (bl) {
                return 1;
            }
            return 2;
        }
        return 0;
    }

    public static void httpdStatus(String string, StartUtil startUtil) {
        String string2 = defHost;
        int n = defPort;
        String string3 = defJarFile;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \"");
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            int n3;
            Object object;
            String string4 = defProtocol;
            String string5 = stringTokenizer.nextToken();
            try {
                object = new URL(string5);
                string4 = ((URL)object).getProtocol();
                string2 = ((URL)object).getHost();
                n3 = ((URL)object).getPort();
                if (n3 != -1) {
                    n = n3;
                }
                string3 = HTTPDStatus.getURLFile((URL)object);
            }
            catch (MalformedURLException malformedURLException) {
                try {
                    string2 = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException unknownHostException) {}
            }
            object = "(" + string5 + ")";
            if ("http".equals(string4) || "ftp".equals(string4)) {
                n3 = HTTPDStatus.httpdStatus(string2, n, string3);
                if (n3 == 0) {
                    startUtil.print("httpserver.down", (String)object);
                } else if (n3 == 2) {
                    startUtil.print("httpserver.nojar", (String)object);
                }
            } else if ("file".equals(string4)) {
                startUtil.print("fileurl.warning", (String)object);
            } else {
                startUtil.print("nonstandardurl.warning", (String)object);
            }
            ++n2;
        }
    }

    public static int httpdStatusAlt(String string, int n, String string2) {
        try {
            URL uRL = new URL("http", string, n, "/" + string2);
            Object object = uRL.getContent();
            if (object != null) {
                return 1;
            }
            return 0;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static void main(String[] stringArray) {
        int n;
        String string = defHost;
        int n2 = defPort;
        String string2 = defJarFile;
        if (stringArray.length > 3) {
            System.err.println("HTTPDUp <hostname> <port> <jarFilename>");
            return;
        }
        int n3 = -1;
        int n4 = 0;
        while (n4 < stringArray.length) {
            try {
                n2 = n = Integer.parseInt(stringArray[n4]);
                n3 = n4;
                break;
            }
            catch (NumberFormatException numberFormatException) {
                ++n4;
            }
        }
        n = -1;
        int n5 = 0;
        while (n5 < stringArray.length) {
            if (stringArray[n5].endsWith(".jar")) {
                string2 = stringArray[n5];
                n = n5;
                break;
            }
            ++n5;
        }
        int n6 = 0;
        while (n6 < stringArray.length) {
            if (n3 != n6 && n != n6) {
                string = stringArray[n6];
                break;
            }
            ++n6;
        }
        int n7 = HTTPDStatus.httpdStatus(string, n2, string2);
        System.out.println(n7);
    }

    private static Socket openSocket(String string, int n) {
        Socket socket = null;
        try {
            socket = new Socket(string, n);
        }
        catch (Exception exception) {}
        return socket;
    }

    private static boolean replyOK(String[] stringArray) {
        int n;
        boolean bl = false;
        if (stringArray == null || stringArray.length == 0) {
            return bl;
        }
        if (stringArray[0].startsWith("HTTP/") && (n = stringArray[0].indexOf(32)) != -1 && stringArray[0].substring(n).startsWith(" 2")) {
            bl = true;
        }
        return bl;
    }

    private static void setSocketLingerOff(Socket socket) {
        if (socket == null) {
            return;
        }
        try {
            socket.setSoLinger(false, 0);
        }
        catch (IOException iOException) {
            System.err.println("\nOn setting socket linger on -- " + iOException.toString());
            iOException.printStackTrace();
        }
    }

    private static void setSocketLingerOn(Socket socket, int n) {
        if (socket == null) {
            return;
        }
        int n2 = n < 0 ? 0 : n;
        try {
            socket.setSoLinger(true, n2);
        }
        catch (IOException iOException) {
            System.err.println("\nOn setting socket linger on -- " + iOException.toString());
            iOException.printStackTrace();
        }
    }

    private static void setSocketTimeout(Socket socket, int n) {
        if (socket == null) {
            return;
        }
        int n2 = n < 0 ? 0 : n;
        try {
            socket.setSoTimeout(n2);
        }
        catch (IOException iOException) {
            System.err.println("\nOn setting socket timeout -- " + iOException.toString());
            iOException.printStackTrace();
        }
    }

    private static void writeGetToSocket(Socket socket, String string) {
        if (socket == null || string == null) {
            return;
        }
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
            dataOutputStream.writeBytes("GET /" + string + " HTTP/1.0\r\n\r\n");
            dataOutputStream.flush();
        }
        catch (Exception exception) {
            System.err.println("\nOn socket write -- " + exception.toString());
            exception.printStackTrace();
        }
    }
}

