/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.start;

import com.sun.jini.start.ParsedArgs;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import net.jini.core.discovery.LookupLocator;
import net.jini.discovery.DiscoveryGroupManagement;

public class StartUtil {
    private static final String resourcePackage = "com.sun.jini.start.resources";
    private String resourceName;
    private ResourceBundle resources;
    private String[] defaultGroups = new String[]{""};

    public StartUtil(String string) {
        this.resourceName = string;
        try {
            this.resources = ResourceBundle.getBundle("com.sun.jini.start.resources." + string);
        }
        catch (MissingResourceException missingResourceException) {
            missingResourceException.printStackTrace();
        }
    }

    private String[] getGroupsFromCommaSeparatedList(String string) {
        if (string.startsWith("-loc")) {
            return DiscoveryGroupManagement.NO_GROUPS;
        }
        String string2 = string;
        if (string.startsWith("-group")) {
            int n = string.indexOf(",");
            string2 = string.substring(n + 1);
        }
        String string3 = this.getString("groups.public");
        String string4 = this.getString("groups.none");
        String string5 = this.getString("groups.all");
        boolean bl = false;
        boolean bl2 = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t\n\r\f,");
        int n = stringTokenizer.countTokens();
        if (n > 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string6 = stringTokenizer.nextToken();
                if (StartUtil.getLocator(string6) != null) {
                    bl2 = true;
                } else {
                    if (string6.equals(string3)) {
                        string6 = "";
                    } else if (string6.equals(string4)) {
                        bl = true;
                    } else if (string6.equals(string5)) {
                        return null;
                    }
                    arrayList.add(string6);
                }
                ++n2;
            }
            if (bl || bl2 && arrayList.size() == 0) {
                return DiscoveryGroupManagement.NO_GROUPS;
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
        return this.defaultGroups;
    }

    private static LookupLocator getLocator(String string) {
        if (StartUtil.isCommaSeparatedList(string)) {
            return null;
        }
        try {
            return new LookupLocator(string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private static LookupLocator[] getLocatorsFromCommaSeparatedList(String string) {
        StringTokenizer stringTokenizer;
        int n;
        if (string.startsWith("-group")) {
            return new LookupLocator[0];
        }
        String string2 = string;
        boolean bl = false;
        if (string.startsWith("-loc")) {
            int n2 = string.indexOf(",");
            string2 = string.substring(n2 + 1);
            bl = true;
        }
        if ((n = (stringTokenizer = new StringTokenizer(string2, " \t\n\r\f,")).countTokens()) > 0) {
            ArrayList<LookupLocator> arrayList = new ArrayList<LookupLocator>();
            int n3 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                LookupLocator lookupLocator = StartUtil.getLocator(string3);
                if (lookupLocator != null) {
                    arrayList.add(lookupLocator);
                } else if (bl && (lookupLocator = StartUtil.hostToLocator(string3)) != null) {
                    arrayList.add(lookupLocator);
                }
                ++n3;
            }
            return arrayList.toArray(new LookupLocator[arrayList.size()]);
        }
        return new LookupLocator[0];
    }

    private String getLogDirectory(String string) {
        return this.getLogDirectory(string, true);
    }

    private String getLogDirectory(String string, boolean bl) {
        if (!this.isValidLogDirectory(string, bl)) {
            return null;
        }
        String string2 = new String(string);
        File file = new File(string2);
        if (!file.isAbsolute()) {
            string2 = file.getAbsolutePath();
            this.print("logdir.abs", string2);
        }
        return string2;
    }

    private String getPolicyFile(String string) {
        return this.getPolicyFile(string, true);
    }

    private String getPolicyFile(String string, boolean bl) {
        if (!this.isValidPolicyFile(string, bl)) {
            return null;
        }
        String string2 = new String(string);
        File file = new File(string2);
        if (!file.isAbsolute()) {
            string2 = file.getAbsolutePath();
            this.print("policy.abs", string2);
        }
        return string2;
    }

    private String getString(String string) {
        String string2 = String.valueOf(this.resourceName) + "." + string;
        try {
            return this.resources.getString(string2);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public String getString(String string, String string2) {
        String string3 = this.getString(string);
        String string4 = String.valueOf(this.resourceName) + "." + string;
        if (string3 == null) {
            string3 = "no text found: \"" + string4 + "\" {0}";
        }
        return MessageFormat.format(string3, string2);
    }

    private static LookupLocator hostToLocator(String string) {
        try {
            return new LookupLocator("jini://" + string + ":4160/");
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private static boolean isClasspath(String string) {
        return string.equals("-classpath") || string.equals("-cp");
    }

    private static boolean isCommaSeparatedList(String string) {
        return string.indexOf(",") >= 0;
    }

    private static boolean isProgram(String string) {
        File file;
        return !string.startsWith("-") && (file = new File(string)).exists() && !file.isDirectory() && file.isAbsolute();
    }

    private static boolean isProperty(String string) {
        return string.startsWith("-") && !string.equals("-classpath") && !string.equals("-cp") && !string.startsWith("-groups") && !string.startsWith("-group") && !string.startsWith("-locators") && !string.startsWith("-locs") && !string.startsWith("-locator") && !string.startsWith("-loc");
    }

    private static boolean isUrl(String string) {
        try {
            URL uRL = new URL(string);
            String string2 = uRL.getProtocol();
            if (string2.equals("http")) {
                return true;
            }
            if (string2.equals("ftp")) {
                return true;
            }
            return string2.equals("file");
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }

    private boolean isValidCodebaseUrl(String string) {
        return this.isValidCodebaseUrl(string, true);
    }

    private boolean isValidCodebaseUrl(String string, boolean bl) {
        boolean bl2 = true;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \"");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!(string2.endsWith("/") || string2.endsWith(".jar") || string2.endsWith(".zip"))) {
                if (!bl) {
                    return false;
                }
                this.print("codebase.slash", string2);
                bl2 = false;
            }
            try {
                new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                if (!bl) {
                    return false;
                }
                this.print("codebase.syntax", string2);
                bl2 = false;
            }
            ++n;
        }
        return bl2;
    }

    private boolean isValidLogDirectory(String string) {
        return this.isValidLogDirectory(string, true);
    }

    private boolean isValidLogDirectory(String string, boolean bl) {
        File file = new File(string);
        if (file.exists()) {
            if (!bl) {
                return false;
            }
            this.print("logdir.exist", string);
            return false;
        }
        if (this.isValidCodebaseUrl(string, false) || this.isValidPolicyFile(string, false) || StartUtil.isClasspath(string) || StartUtil.isProperty(string) || StartUtil.isProgram(string) || StartUtil.isCommaSeparatedList(string)) {
            if (!bl) {
                return false;
            }
            this.print("logdir.invalid", string);
            return false;
        }
        return true;
    }

    private boolean isValidPolicyFile(String string) {
        return this.isValidPolicyFile(string, true);
    }

    private boolean isValidPolicyFile(String string, boolean bl) {
        File file = new File(string);
        if (!file.exists()) {
            if (!bl) {
                return false;
            }
            this.print("policy.exist", string);
            return false;
        }
        return true;
    }

    public ParsedArgs parseActivatableArgs(String[] stringArray) {
        if (stringArray == null || stringArray.length < 3) {
            return null;
        }
        String string = System.getProperty("java.class.path");
        String string2 = stringArray[0];
        String string3 = this.getPolicyFile(stringArray[1]);
        String string4 = this.getLogDirectory(stringArray[2]);
        if (!this.isValidCodebaseUrl(string2) || string3 == null || string4 == null) {
            return null;
        }
        ParsedArgs parsedArgs = this.parseArgs(stringArray, 3);
        return new ParsedArgs(string2, string3, string4, parsedArgs.getGroups(), parsedArgs.getLocators(), parsedArgs.getJavaProgram(), parsedArgs.getProperties(), parsedArgs.getOptions());
    }

    public ParsedArgs parseArgs(String[] stringArray) {
        return this.parseArgs(stringArray, 0);
    }

    public ParsedArgs parseArgs(String[] stringArray, int n) {
        String[] stringArray2;
        boolean bl = true;
        String[] stringArray3 = this.defaultGroups;
        LookupLocator[] lookupLocatorArray = new LookupLocator[]{};
        String string = null;
        Properties properties = null;
        String[] stringArray4 = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        int n2 = n;
        while (n2 < stringArray.length) {
            int n3;
            ParsedListResult parsedListResult;
            if (StartUtil.isClasspath(stringArray[n2])) {
                if (stringArray.length <= n2 + 1) {
                    this.print("classpath.invalid", null);
                    bl = false;
                    break;
                }
                arrayList4.add(stringArray[n2]);
                arrayList4.add(stringArray[n2 + 1]);
                n2 += 2;
                continue;
            }
            if (StartUtil.isProperty(stringArray[n2])) {
                arrayList3.add(stringArray[n2]);
                ++n2;
                continue;
            }
            if (StartUtil.isProgram(stringArray[n2])) {
                string = stringArray[n2];
                ++n2;
                continue;
            }
            LookupLocator lookupLocator = StartUtil.getLocator(stringArray[n2]);
            if (lookupLocator != null) {
                arrayList2.add(lookupLocator);
                ++n2;
                continue;
            }
            if (StartUtil.isCommaSeparatedList(stringArray[n2])) {
                stringArray2 = this.getGroupsFromCommaSeparatedList(stringArray[n2]);
                if (stringArray3 != null) {
                    if (stringArray2 == null) {
                        stringArray3 = null;
                    } else if (stringArray2 == DiscoveryGroupManagement.NO_GROUPS) {
                        stringArray3 = DiscoveryGroupManagement.NO_GROUPS;
                    } else {
                        int n4 = 0;
                        while (n4 < stringArray2.length) {
                            arrayList.add(stringArray2[n4]);
                            ++n4;
                        }
                    }
                }
                LookupLocator[] lookupLocatorArray2 = StartUtil.getLocatorsFromCommaSeparatedList(stringArray[n2]);
                int n5 = 0;
                while (n5 < lookupLocatorArray2.length) {
                    arrayList2.add(lookupLocatorArray2[n5]);
                    ++n5;
                }
                ++n2;
                continue;
            }
            if (stringArray[n2].equals("-groups") || stringArray[n2].equals("-group")) {
                if (n2 + 1 == stringArray.length) {
                    this.print("groups.invalid", null);
                    bl = false;
                    break;
                }
                int n6 = n2 + 1;
                int n7 = stringArray.length - n6;
                String[] stringArray5 = new String[n7];
                System.arraycopy(stringArray, n6, stringArray5, 0, n7);
                parsedListResult = StartUtil.parseGroupList(stringArray5);
                n3 = 0;
                while (n3 < parsedListResult.extractedArgs.length) {
                    arrayList.add(parsedListResult.extractedArgs[n3]);
                    ++n3;
                }
                n2 = n2 + parsedListResult.nArgsParsed + 1;
                continue;
            }
            if (stringArray[n2].equals("-locators") || stringArray[n2].equals("-locs") || stringArray[n2].equals("-locator") || stringArray[n2].equals("-loc")) {
                if (n2 + 1 == stringArray.length) {
                    this.print("locators.invalid", null);
                    bl = false;
                    break;
                }
                int n8 = n2 + 1;
                int n9 = stringArray.length - n8;
                String[] stringArray6 = new String[n9];
                System.arraycopy(stringArray, n8, stringArray6, 0, n9);
                parsedListResult = StartUtil.parseLocatorList(stringArray6);
                n3 = 0;
                while (n3 < parsedListResult.extractedArgs.length) {
                    arrayList2.add(parsedListResult.extractedArgs[n3]);
                    ++n3;
                }
                n2 = n2 + parsedListResult.nArgsParsed + 1;
                continue;
            }
            if (stringArray3 != null) {
                if (stringArray[n2].equals(this.getString("groups.all"))) {
                    stringArray3 = null;
                } else if (stringArray[n2].equals(this.getString("groups.none"))) {
                    stringArray3 = DiscoveryGroupManagement.NO_GROUPS;
                } else if (stringArray[n2].equals(this.getString("groups.public"))) {
                    arrayList.add("");
                } else {
                    arrayList.add(stringArray[n2]);
                }
            }
            ++n2;
        }
        if (!bl) {
            return null;
        }
        if (!arrayList.isEmpty()) {
            stringArray3 = arrayList.toArray(new String[arrayList.size()]);
        }
        if (!arrayList2.isEmpty()) {
            lookupLocatorArray = arrayList2.toArray(new LookupLocator[arrayList2.size()]);
            if (arrayList.isEmpty() && stringArray3 != null) {
                stringArray3 = DiscoveryGroupManagement.NO_GROUPS;
            }
        }
        if (!arrayList3.isEmpty()) {
            properties = new Properties();
            int n10 = 0;
            while (n10 < arrayList3.size()) {
                stringArray2 = (String[])arrayList3.get(n10);
                int n11 = stringArray2.indexOf("=");
                if (n11 < 0) {
                    ((Hashtable)properties).put(stringArray2.substring(2), "");
                } else {
                    ((Hashtable)properties).put(stringArray2.substring(2, n11), stringArray2.substring(n11 + 1));
                }
                ++n10;
            }
        }
        if (!arrayList4.isEmpty()) {
            stringArray4 = arrayList4.toArray(new String[arrayList4.size()]);
        }
        return new ParsedArgs(null, null, null, stringArray3, lookupLocatorArray, string, properties, stringArray4);
    }

    private static ParsedListResult parseGroupList(String[] stringArray) {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].startsWith("-") || StartUtil.isClasspath(stringArray[n2]) || StartUtil.isProperty(stringArray[n2]) || StartUtil.isProgram(stringArray[n2])) break;
            object = StartUtil.getLocator(stringArray[n2]);
            if (object == null) {
                arrayList.add(stringArray[n2]);
            }
            ++n;
            ++n2;
        }
        object = arrayList.toArray(new String[arrayList.size()]);
        return new ParsedListResult(n, (Object[])object);
    }

    private static ParsedListResult parseLocatorList(String[] stringArray) {
        Object object;
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].startsWith("-") || StartUtil.isClasspath(stringArray[n2]) || StartUtil.isProperty(stringArray[n2]) || StartUtil.isProgram(stringArray[n2])) break;
            object = StartUtil.getLocator(stringArray[n2]);
            if (object != null) {
                arrayList.add((Object[])object);
            } else {
                object = StartUtil.hostToLocator(stringArray[n2]);
                if (object != null) {
                    arrayList.add((Object[])object);
                }
            }
            ++n;
            ++n2;
        }
        object = arrayList.toArray(new LookupLocator[arrayList.size()]);
        return new ParsedListResult(n, (Object[])object);
    }

    public ParsedArgs parseTransientArgs(String[] stringArray) {
        if (stringArray == null || stringArray.length < 1) {
            return null;
        }
        String string = this.getLogDirectory(stringArray[0]);
        if (string == null) {
            return null;
        }
        ParsedArgs parsedArgs = this.parseArgs(stringArray, 1);
        return new ParsedArgs(null, null, string, parsedArgs.getGroups(), parsedArgs.getLocators(), parsedArgs.getJavaProgram(), parsedArgs.getProperties(), parsedArgs.getOptions());
    }

    public void print(String string, String string2) {
        String string3 = this.getString(string);
        String string4 = String.valueOf(this.resourceName) + "." + string;
        if (string3 == null) {
            string3 = "no text found: \"" + string4 + "\" {0}";
        }
        System.out.println(MessageFormat.format(string3, string2));
    }

    public static void printParsedArgs(ParsedArgs parsedArgs) {
        System.out.println("codebase    = " + parsedArgs.getCodebase());
        System.out.println("policyFile  = " + parsedArgs.getPolicyFile());
        System.out.println("logDir      = " + parsedArgs.getLogDir());
        String[] stringArray = parsedArgs.getGroups();
        if (stringArray == null) {
            System.out.println("groups      = ALL_GROUPS");
        } else if (stringArray.length == 0) {
            System.out.println("groups      = NO_GROUPS");
        } else {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equals("")) {
                    System.out.println("  groups[" + n + "] = The PUBLIC Group");
                } else {
                    System.out.println("  groups[" + n + "] = " + stringArray[n]);
                }
                ++n;
            }
        }
        LookupLocator[] lookupLocatorArray = parsedArgs.getLocators();
        if (lookupLocatorArray == null) {
            System.out.println("locators    = null");
        } else if (lookupLocatorArray.length == 0) {
            System.out.println("locators    = NO_LOCATORS");
        } else {
            int n = 0;
            while (n < lookupLocatorArray.length) {
                System.out.println("  locators[" + n + "] = " + lookupLocatorArray[n]);
                ++n;
            }
        }
        System.out.println("javaProgram = " + parsedArgs.getJavaProgram());
        Properties properties = parsedArgs.getProperties();
        if (properties == null) {
            System.out.println("properties  = null");
        } else {
            properties.list(System.out);
        }
        String[] stringArray2 = parsedArgs.getOptions();
        if (stringArray2 == null) {
            System.out.println("options  = null");
        } else {
            int n = 0;
            while (n < stringArray2.length) {
                System.out.println("  options[" + n + "] = " + stringArray2[n]);
                ++n;
            }
        }
    }

    public void printTransientUsage() {
        this.print("transient.usage", null);
        this.print("groups.usage", null);
        this.print("locators.usage", null);
    }

    public void printUsage() {
        this.print("usage", null);
        this.print("groups.usage", null);
        this.print("locators.usage", null);
        this.print("javaprog.usage", null);
        this.print("properties.usage", null);
        this.print("options.usage", null);
    }

    public static class ParsedListResult {
        public int nArgsParsed;
        public Object[] extractedArgs;

        public ParsedListResult(int n, Object[] objectArray) {
            this.nArgsParsed = n;
            this.extractedArgs = objectArray;
        }
    }
}

