/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.thread;

public class ReadersWriter {
    private int activeReaders = 0;
    private int waitingWriters = 0;
    private boolean activeWriter = false;

    public synchronized void readLock() {
        while (this.activeWriter || this.waitingWriters != 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                throw new ConcurrentLockException("read lock interrupted in thread");
            }
        }
        ++this.activeReaders;
    }

    public synchronized void readUnlock() {
        --this.activeReaders;
        if (this.activeReaders == 0) {
            this.notifyAll();
        }
    }

    public void readerWait(Object object, long l) {
        try {
            try {
                Object object2 = object;
                synchronized (object2) {
                    this.readUnlock();
                    object.wait(l);
                }
            }
            catch (InterruptedException interruptedException) {
                throw new ConcurrentLockException("read wait interrupted in thread");
            }
            Object var5_4 = null;
            this.readLock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.readLock();
            throw throwable;
        }
    }

    public void waiterNotify(Object object) {
        Object object2 = object;
        synchronized (object2) {
            object.notifyAll();
        }
    }

    public synchronized void writeLock() {
        while (this.activeWriter || this.activeReaders != 0) {
            try {
                ++this.waitingWriters;
                try {
                    this.wait();
                }
                finally {
                    Object var2_1 = null;
                    --this.waitingWriters;
                }
            }
            catch (InterruptedException interruptedException) {
                throw new ConcurrentLockException("write lock interrupted in thread");
            }
        }
        this.activeWriter = true;
    }

    public synchronized void writeUnlock() {
        this.activeWriter = false;
        this.notifyAll();
    }

    public void writerWait(Object object, long l) {
        try {
            try {
                Object object2 = object;
                synchronized (object2) {
                    this.writeUnlock();
                    object.wait(l);
                }
            }
            catch (InterruptedException interruptedException) {
                throw new ConcurrentLockException("write wait interrupted in thread");
            }
            Object var5_4 = null;
            this.writeLock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.writeLock();
            throw throwable;
        }
    }

    public static class ConcurrentLockException
    extends RuntimeException {
        private static final long serialVersionUID = 7027246653257040584L;

        public ConcurrentLockException() {
        }

        public ConcurrentLockException(String string) {
            super(string);
        }
    }
}

