/*
 * Decompiled with CFR 0.152.
 */
package net.jini.discovery;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import net.jini.core.lookup.ServiceID;

public class IncomingMulticastRequest {
    protected InetAddress addr;
    protected int port;
    protected ServiceID[] serviceIDs;
    protected String[] groups;
    protected final int protoVersion = 1;

    public IncomingMulticastRequest(DatagramPacket datagramPacket) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(datagramPacket.getData());
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        int n = dataInputStream.readInt();
        if (n != 1) {
            throw new IOException("unsupported protocol version: " + n);
        }
        this.port = dataInputStream.readInt();
        if (this.port <= 0 || this.port >= 65536) {
            throw new IOException("port number out of range: " + this.port);
        }
        int n2 = dataInputStream.readInt();
        if (n2 < 0 || n2 > byteArrayInputStream.available() / 8) {
            throw new IOException("service ID count invalid: " + n2);
        }
        this.serviceIDs = new ServiceID[n2];
        int n3 = 0;
        while (n3 < this.serviceIDs.length) {
            this.serviceIDs[n3] = new ServiceID(dataInputStream);
            ++n3;
        }
        int n4 = dataInputStream.readInt();
        if (n4 < 0 || n4 > byteArrayInputStream.available() / 2) {
            throw new IOException("group count invalid: " + n4);
        }
        this.groups = new String[n4];
        int n5 = 0;
        while (n5 < this.groups.length) {
            this.groups[n5] = dataInputStream.readUTF();
            ++n5;
        }
        this.addr = datagramPacket.getAddress();
    }

    public boolean equals(Object object) {
        if (object instanceof IncomingMulticastRequest) {
            IncomingMulticastRequest incomingMulticastRequest = (IncomingMulticastRequest)object;
            if (incomingMulticastRequest.addr.equals(this.addr) && incomingMulticastRequest.port == this.port && incomingMulticastRequest.groups.length == this.groups.length && incomingMulticastRequest.serviceIDs.length == this.serviceIDs.length) {
                int n = 0;
                while (n < this.groups.length) {
                    if (!this.groups[n].equals(incomingMulticastRequest.groups[n])) {
                        return false;
                    }
                    ++n;
                }
                int n2 = 0;
                while (n2 < this.serviceIDs.length) {
                    if (!this.serviceIDs[n2].equals(incomingMulticastRequest.serviceIDs[n2])) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
        }
        return false;
    }

    public InetAddress getAddress() {
        return this.addr;
    }

    public String[] getGroups() {
        return this.groups;
    }

    public int getPort() {
        return this.port;
    }

    public ServiceID[] getServiceIDs() {
        return this.serviceIDs;
    }

    public int hashCode() {
        byte[] byArray = this.addr.getAddress();
        int n = byArray[0] << 3 ^ byArray[1] << 7 ^ byArray[2] << 5 ^ byArray[3] << 1 ^ ~this.port;
        int n2 = 0;
        while (n2 < this.groups.length) {
            n ^= this.groups[n2].hashCode() << n2;
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.serviceIDs.length) {
            n ^= this.serviceIDs[n3].hashCode() << n3;
            ++n3;
        }
        return n;
    }
}

