/*
 * Decompiled with CFR 0.152.
 */
package net.jini.discovery;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.DiscoveryLocatorManagement;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.IncomingUnicastResponse;
import net.jini.discovery.OutgoingUnicastRequest;

public class LookupLocatorDiscovery
implements DiscoveryManagement,
DiscoveryLocatorManagement {
    private final TreeMap locatorsMap = new TreeMap();
    private final ArrayList discoveredLocators = new ArrayList(1);
    private DiscoveryThread discoveryThread = null;
    private Notifier notifierThread;
    private LinkedList pendingNotifies = new LinkedList();
    private final ArrayList listeners = new ArrayList(1);
    private LocatorReg regInRMICall = null;
    private static final int unicastSocketTimeout = (Integer)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            int n = 60000;
            try {
                return Integer.getInteger("net.jini.discovery.timeout", n);
            }
            catch (SecurityException securityException) {
                return new Integer(n);
            }
        }
    });

    public LookupLocatorDiscovery(LookupLocator[] lookupLocatorArray) {
        LookupLocatorDiscovery lookupLocatorDiscovery = this;
        synchronized (lookupLocatorDiscovery) {
            this.discoverLocators(lookupLocatorArray);
        }
    }

    static /* synthetic */ DiscoveryThread access$3(LookupLocatorDiscovery lookupLocatorDiscovery) {
        return lookupLocatorDiscovery.discoveryThread;
    }

    static /* synthetic */ Notifier access$9(LookupLocatorDiscovery lookupLocatorDiscovery) {
        return lookupLocatorDiscovery.notifierThread;
    }

    public void addDiscoveryListener(DiscoveryListener discoveryListener) {
        if (discoveryListener == null) {
            throw new NullPointerException("can't add null listener");
        }
        LookupLocatorDiscovery lookupLocatorDiscovery = this;
        synchronized (lookupLocatorDiscovery) {
            if (this.listeners.contains(discoveryListener)) {
                Object var3_3 = null;
                return;
            }
            this.listeners.add(discoveryListener);
            if (!this.discoveredLocators.isEmpty()) {
                Object object;
                HashMap<ServiceRegistrar, String[]> hashMap = new HashMap<ServiceRegistrar, String[]>(this.discoveredLocators.size());
                Iterator iterator = ((AbstractList)this.discoveredLocators).iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    object = (LocatorReg)iterator.next();
                    hashMap.put(((LocatorReg)object).proxy, ((LocatorReg)object).memberGroups);
                    ++n;
                }
                object = new ArrayList(1);
                ((ArrayList)object).add(discoveryListener);
                this.addNotify((ArrayList)object, hashMap, false);
            }
        }
    }

    public synchronized void addLocators(LookupLocator[] lookupLocatorArray) {
        this.testSetForNull(lookupLocatorArray);
        this.discoverLocators(lookupLocatorArray);
    }

    private void addNotify(ArrayList arrayList, Map map, boolean bl) {
        LinkedList linkedList = this.pendingNotifies;
        synchronized (linkedList) {
            this.pendingNotifies.addLast(new NotifyTask(arrayList, map, bl));
            if (this.notifierThread == null) {
                this.notifierThread = new Notifier();
                this.notifierThread.start();
            }
        }
    }

    private void addToMap(LocatorReg locatorReg) {
        this.locatorsMap.put(locatorReg, locatorReg);
        if (this.discoveryThread == null) {
            this.discoveryThread = new DiscoveryThread();
            this.discoveryThread.start();
        } else {
            this.notifyAll();
        }
    }

    private ServiceRegistrar[] buildServiceRegistrar() {
        int n = 0;
        ServiceRegistrar[] serviceRegistrarArray = new ServiceRegistrar[this.discoveredLocators.size()];
        Iterator iterator = ((AbstractList)this.discoveredLocators).iterator();
        while (iterator.hasNext()) {
            LocatorReg locatorReg = (LocatorReg)iterator.next();
            serviceRegistrarArray[n++] = locatorReg.proxy;
        }
        return serviceRegistrarArray;
    }

    private boolean checkRegInRMICall(LookupLocator lookupLocator) {
        if (this.regInRMICall == null) {
            return false;
        }
        return this.regInRMICall.l.equals(lookupLocator);
    }

    private Map deepCopy(HashMap hashMap) {
        HashMap hashMap2 = (HashMap)hashMap.clone();
        Set set = hashMap2.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            entry.setValue(((String[])entry.getValue()).clone());
        }
        return hashMap2;
    }

    public void discard(ServiceRegistrar serviceRegistrar) {
        if (serviceRegistrar == null) {
            return;
        }
        LookupLocatorDiscovery lookupLocatorDiscovery = this;
        synchronized (lookupLocatorDiscovery) {
            LookupLocator lookupLocator = this.findRegFromProxy(serviceRegistrar);
            if (lookupLocator == null) {
                Object var3_4 = null;
                return;
            }
            LocatorReg locatorReg = this.removeDiscoveredLocator(lookupLocator);
            HashMap<ServiceRegistrar, String[]> hashMap = new HashMap<ServiceRegistrar, String[]>(1);
            hashMap.put(locatorReg.proxy, locatorReg.memberGroups);
            locatorReg.proxy = null;
            locatorReg.memberGroups = null;
            locatorReg.fixupNextTryTime();
            locatorReg.calcNextTryTime();
            this.addToMap(locatorReg);
            if (!this.listeners.isEmpty()) {
                this.addNotify((ArrayList)this.listeners.clone(), hashMap, true);
            }
        }
    }

    private void discoverLocators(LookupLocator[] lookupLocatorArray) {
        if (lookupLocatorArray == null) {
            return;
        }
        int n = 0;
        while (n < lookupLocatorArray.length) {
            LocatorReg locatorReg;
            if (!this.isDiscovered(lookupLocatorArray[n]) && (locatorReg = this.findReg(lookupLocatorArray[n])) == null) {
                locatorReg = new LocatorReg(lookupLocatorArray[n]);
                this.addToMap(locatorReg);
            }
            ++n;
        }
    }

    private LocatorReg findReg(LookupLocator lookupLocator) {
        if (this.checkRegInRMICall(lookupLocator)) {
            return this.regInRMICall;
        }
        Iterator iterator = this.locatorsMap.values().iterator();
        while (iterator.hasNext()) {
            LocatorReg locatorReg = (LocatorReg)iterator.next();
            if (!locatorReg.l.equals(lookupLocator)) continue;
            return locatorReg;
        }
        return null;
    }

    private LookupLocator findRegFromProxy(ServiceRegistrar serviceRegistrar) {
        Iterator iterator = ((AbstractList)this.discoveredLocators).iterator();
        while (iterator.hasNext()) {
            LocatorReg locatorReg = (LocatorReg)iterator.next();
            if (!locatorReg.proxy.equals(serviceRegistrar)) continue;
            return locatorReg.l;
        }
        return null;
    }

    public synchronized LookupLocator[] getDiscoveredLocators() {
        int n = this.discoveredLocators.size();
        LookupLocator[] lookupLocatorArray = new LookupLocator[n];
        int n2 = 0;
        Iterator iterator = ((AbstractList)this.discoveredLocators).iterator();
        while (iterator.hasNext()) {
            lookupLocatorArray[n2++] = ((LocatorReg)iterator.next()).l;
        }
        return lookupLocatorArray;
    }

    public synchronized LookupLocator[] getLocators() {
        int n = this.discoveredLocators.size() + this.locatorsMap.size();
        if (this.regInRMICall != null) {
            ++n;
        }
        LookupLocator[] lookupLocatorArray = new LookupLocator[n];
        int n2 = 0;
        Iterator<Object> iterator = ((AbstractList)this.discoveredLocators).iterator();
        while (iterator.hasNext()) {
            lookupLocatorArray[n2++] = ((LocatorReg)iterator.next()).l;
        }
        iterator = this.locatorsMap.values().iterator();
        while (iterator.hasNext()) {
            lookupLocatorArray[n2++] = ((LocatorReg)iterator.next()).l;
        }
        if (this.regInRMICall != null) {
            lookupLocatorArray[n2] = this.regInRMICall.l;
        }
        return lookupLocatorArray;
    }

    public ServiceRegistrar[] getRegistrars() {
        LookupLocatorDiscovery lookupLocatorDiscovery = this;
        synchronized (lookupLocatorDiscovery) {
            if (this.discoveredLocators == null || this.discoveredLocators.isEmpty()) {
                ServiceRegistrar[] serviceRegistrarArray = new ServiceRegistrar[]{};
                Object var3_4 = null;
                return serviceRegistrarArray;
            }
            ServiceRegistrar[] serviceRegistrarArray = this.buildServiceRegistrar();
            Object var3_5 = null;
            return serviceRegistrarArray;
        }
    }

    public synchronized LookupLocator[] getUndiscoveredLocators() {
        int n = this.locatorsMap.size();
        if (this.regInRMICall != null) {
            ++n;
        }
        LookupLocator[] lookupLocatorArray = new LookupLocator[n];
        int n2 = 0;
        Iterator iterator = this.locatorsMap.values().iterator();
        while (iterator.hasNext()) {
            lookupLocatorArray[n2++] = ((LocatorReg)iterator.next()).l;
        }
        if (this.regInRMICall != null) {
            lookupLocatorArray[n2] = this.regInRMICall.l;
        }
        return lookupLocatorArray;
    }

    private boolean isArrayContains(Object[] objectArray, Object object) {
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n].equals(object)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean isDiscovered(LookupLocator lookupLocator) {
        Iterator iterator = ((AbstractList)this.discoveredLocators).iterator();
        while (iterator.hasNext()) {
            LocatorReg locatorReg = (LocatorReg)iterator.next();
            if (!locatorReg.l.equals(lookupLocator)) continue;
            return true;
        }
        return false;
    }

    private Map mapRegToGroups(ServiceRegistrar serviceRegistrar, String[] stringArray) {
        HashMap<ServiceRegistrar, String[]> hashMap = new HashMap<ServiceRegistrar, String[]>(1);
        hashMap.put(serviceRegistrar, stringArray);
        return hashMap;
    }

    private static void printException(Exception exception) {
        try {
            if (System.getProperty("net.jini.discovery.debug") != null) {
                exception.printStackTrace();
            }
        }
        catch (SecurityException securityException) {}
    }

    private void printMap() {
        Iterator iterator = this.locatorsMap.values().iterator();
        while (iterator.hasNext()) {
            LocatorReg locatorReg = (LocatorReg)iterator.next();
            System.out.println("printMap reg:" + locatorReg.id);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void regTryGetProxy(LocatorReg locatorReg) {
        boolean bl = locatorReg.tryGetProxy();
        LookupLocatorDiscovery lookupLocatorDiscovery = this;
        synchronized (lookupLocatorDiscovery) {
            if (this.regInRMICall == null) {
                return;
            }
            this.regInRMICall = null;
            if (bl) {
                this.discoveredLocators.add(locatorReg);
                if (this.listeners.isEmpty()) return;
                this.addNotify((ArrayList)this.listeners.clone(), this.mapRegToGroups(locatorReg.proxy, locatorReg.memberGroups), false);
                return;
            }
            this.addToMap(locatorReg);
            return;
        }
    }

    private LocatorReg removeDiscoveredLocator(LookupLocator lookupLocator) {
        Iterator iterator = ((AbstractList)this.discoveredLocators).iterator();
        while (iterator.hasNext()) {
            LocatorReg locatorReg = (LocatorReg)iterator.next();
            if (!locatorReg.l.equals(lookupLocator)) continue;
            iterator.remove();
            return locatorReg;
        }
        return null;
    }

    public synchronized void removeDiscoveryListener(DiscoveryListener discoveryListener) {
        int n = this.listeners.indexOf(discoveryListener);
        if (n != -1) {
            this.listeners.remove(n);
        }
    }

    private void removeLocatorReg(LocatorReg locatorReg) {
        if (locatorReg == this.regInRMICall) {
            this.regInRMICall = null;
        } else {
            this.locatorsMap.remove(locatorReg);
        }
    }

    public void removeLocators(LookupLocator[] lookupLocatorArray) {
        this.testSetForNull(lookupLocatorArray);
        LookupLocatorDiscovery lookupLocatorDiscovery = this;
        synchronized (lookupLocatorDiscovery) {
            HashMap<ServiceRegistrar, String[]> hashMap = new HashMap<ServiceRegistrar, String[]>(1);
            int n = 0;
            while (n < lookupLocatorArray.length) {
                LocatorReg locatorReg = this.removeDiscoveredLocator(lookupLocatorArray[n]);
                if (locatorReg != null) {
                    hashMap.put(locatorReg.proxy, locatorReg.memberGroups);
                } else {
                    locatorReg = this.findReg(lookupLocatorArray[n]);
                    if (locatorReg != null) {
                        this.removeLocatorReg(locatorReg);
                        this.notifyAll();
                    }
                }
                ++n;
            }
            if (!hashMap.isEmpty() && !this.listeners.isEmpty()) {
                this.addNotify((ArrayList)this.listeners.clone(), hashMap, true);
            }
        }
    }

    public void setLocators(LookupLocator[] lookupLocatorArray) {
        this.testSetForNull(lookupLocatorArray);
        LookupLocatorDiscovery lookupLocatorDiscovery = this;
        synchronized (lookupLocatorDiscovery) {
            LocatorReg locatorReg;
            HashMap<ServiceRegistrar, String[]> hashMap = new HashMap<ServiceRegistrar, String[]>(1);
            Iterator<Object> iterator = ((AbstractList)this.discoveredLocators).iterator();
            while (iterator.hasNext()) {
                locatorReg = (LocatorReg)iterator.next();
                if (this.isArrayContains(lookupLocatorArray, locatorReg.l)) continue;
                iterator.remove();
                hashMap.put(locatorReg.proxy, locatorReg.memberGroups);
            }
            iterator = this.locatorsMap.values().iterator();
            while (iterator.hasNext()) {
                locatorReg = (LocatorReg)iterator.next();
                if (this.isArrayContains(lookupLocatorArray, locatorReg.l)) continue;
                iterator.remove();
            }
            if (this.regInRMICall != null && !this.isArrayContains(lookupLocatorArray, this.regInRMICall.l)) {
                this.regInRMICall = null;
            }
            this.discoverLocators(lookupLocatorArray);
            if (!hashMap.isEmpty() && !this.listeners.isEmpty()) {
                this.addNotify((ArrayList)this.listeners.clone(), hashMap, true);
            }
        }
    }

    public synchronized void terminate() {
        if (this.discoveryThread != null) {
            this.discoveryThread.interrupt();
        }
        this.regInRMICall = null;
    }

    private void testSetForNull(LookupLocator[] lookupLocatorArray) {
        if (lookupLocatorArray == null) {
            throw new NullPointerException("null locator array");
        }
        int n = 0;
        while (n < lookupLocatorArray.length) {
            if (lookupLocatorArray[n] == null) {
                throw new NullPointerException("null element in locator array");
            }
            ++n;
        }
    }

    private static class LocatorReg
    implements Comparable {
        public ServiceRegistrar proxy = null;
        public final LookupLocator l;
        public String[] memberGroups = null;
        private static final long MINI_RETRY = 15000L;
        private static final long[] sleepTime;
        private static int cnt;
        public long nextTryTime;
        private int numFails = 0;
        private final int id = cnt++;
        private long time = 0L;

        static {
            long[] lArray = new long[10];
            lArray[1] = 5000L;
            lArray[2] = 10000L;
            lArray[3] = 20000L;
            lArray[4] = 30000L;
            lArray[5] = 60000L;
            lArray[6] = 120000L;
            lArray[7] = 240000L;
            lArray[8] = 480000L;
            lArray[9] = 900000L;
            sleepTime = lArray;
            cnt = 0;
        }

        public LocatorReg(LookupLocator lookupLocator) {
            this.l = lookupLocator;
            this.calcNextTryTime();
        }

        public void calcNextTryTime() {
            this.nextTryTime = System.currentTimeMillis() + sleepTime[this.numFails];
            if (this.numFails < sleepTime.length - 1) {
                ++this.numFails;
            }
        }

        public int compareTo(Object object) {
            if (this.equals(object)) {
                return 0;
            }
            LocatorReg locatorReg = (LocatorReg)object;
            if (this.nextTryTime == locatorReg.nextTryTime) {
                if (this.id < locatorReg.id) {
                    return 1;
                }
                return -1;
            }
            if (this.nextTryTime < locatorReg.nextTryTime) {
                return 1;
            }
            return -1;
        }

        private void doUnicastDiscovery(LookupLocator lookupLocator) throws UnknownHostException, SocketException, IOException, ClassNotFoundException {
            Socket socket = new Socket(lookupLocator.getHost(), lookupLocator.getPort());
            try {
                socket.setSoTimeout(unicastSocketTimeout);
                OutputStream outputStream = socket.getOutputStream();
                InputStream inputStream = socket.getInputStream();
                OutgoingUnicastRequest.marshal(outputStream);
                IncomingUnicastResponse incomingUnicastResponse = new IncomingUnicastResponse(inputStream);
                this.proxy = incomingUnicastResponse.getRegistrar();
                this.memberGroups = incomingUnicastResponse.getGroups();
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            Object var4_6 = null;
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }

        public boolean equals(Object object) {
            return this.l.equals(((LocatorReg)object).l);
        }

        public void fixupNextTryTime() {
            if (System.currentTimeMillis() - this.time > 15000L) {
                this.numFails = 0;
            }
        }

        public int hashCode() {
            return this.l.hashCode();
        }

        public boolean tryGetProxy() {
            if (this.proxy != null) {
                throw new IllegalArgumentException("LookupLocator has been discovered already");
            }
            try {
                this.doUnicastDiscovery(this.l);
                this.time = System.currentTimeMillis();
                return true;
            }
            catch (Exception exception) {
                LookupLocatorDiscovery.printException(exception);
                this.calcNextTryTime();
                return false;
            }
        }
    }

    private class DiscoveryThread
    extends Thread {
        public DiscoveryThread() {
            super("DiscoveryThread");
            this.setDaemon(true);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                while (true) {
                    block10: {
                        if (this.isInterrupted()) {
                            return;
                        }
                        LookupLocatorDiscovery lookupLocatorDiscovery = LookupLocatorDiscovery.this;
                        synchronized (lookupLocatorDiscovery) {
                            block9: {
                                if (LookupLocatorDiscovery.this.locatorsMap.isEmpty()) {
                                    LookupLocatorDiscovery.this.discoveryThread = null;
                                    return;
                                }
                                LocatorReg locatorReg = (LocatorReg)LookupLocatorDiscovery.this.locatorsMap.lastKey();
                                long l = locatorReg.nextTryTime;
                                long l2 = System.currentTimeMillis();
                                if (l > l2) {
                                    LookupLocatorDiscovery.this.wait(l - l2);
                                    break block9;
                                }
                                LookupLocatorDiscovery.this.regInRMICall = locatorReg;
                                LookupLocatorDiscovery.this.locatorsMap.remove(locatorReg);
                                break block10;
                            }
                            Object var2_2 = null;
                            continue;
                        }
                    }
                    LookupLocatorDiscovery.this.regTryGetProxy(LookupLocatorDiscovery.this.regInRMICall);
                }
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static class NotifyTask {
        public final ArrayList listeners;
        public final Map groupsMap;
        public final boolean discard;

        public NotifyTask(ArrayList arrayList, Map map, boolean bl) {
            this.listeners = arrayList;
            this.groupsMap = map;
            this.discard = bl;
        }
    }

    private class Notifier
    extends Thread {
        public Notifier() {
            super("event notifier");
            this.setDaemon(true);
        }

        public void run() {
            block3: while (true) {
                NotifyTask notifyTask;
                DiscoveryListener discoveryListener;
                Object object = LookupLocatorDiscovery.this.pendingNotifies;
                synchronized (object) {
                    if (LookupLocatorDiscovery.this.pendingNotifies.isEmpty()) {
                        LookupLocatorDiscovery.this.notifierThread = null;
                        discoveryListener = null;
                        return;
                    }
                    notifyTask = (NotifyTask)LookupLocatorDiscovery.this.pendingNotifies.removeFirst();
                }
                object = ((AbstractList)notifyTask.listeners).iterator();
                while (true) {
                    if (!object.hasNext()) continue block3;
                    discoveryListener = (DiscoveryListener)object.next();
                    DiscoveryEvent discoveryEvent = new DiscoveryEvent((Object)LookupLocatorDiscovery.this, LookupLocatorDiscovery.this.deepCopy((HashMap)notifyTask.groupsMap));
                    if (notifyTask.discard) {
                        discoveryListener.discarded(discoveryEvent);
                        continue;
                    }
                    discoveryListener.discovered(discoveryEvent);
                }
                break;
            }
        }
    }
}

