/*
 * Decompiled with CFR 0.152.
 */
package net.jini.lease;

import com.sun.jini.constants.ThrowableConstants;
import com.sun.jini.thread.TaskManager;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.jini.core.lease.Lease;
import net.jini.core.lease.LeaseMap;
import net.jini.core.lease.LeaseMapException;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.lease.DesiredExpirationListener;
import net.jini.lease.LeaseListener;
import net.jini.lease.LeaseRenewalEvent;

public class LeaseRenewalManager {
    private static final long RENEW_BATCH_TIME_GAP = 300000L;
    private static final long RENEW_RTT = 10000L;
    private static final int MAX_RENEW_THREAD = 10;
    private final SortedMap leases = new TreeMap();
    private final List leaseInRenew = new ArrayList(1);
    private QueuerTask queuer = null;
    TaskManager tasker = new TaskManager(11, 15000L, 1.0f);
    private final List calcList = new ArrayList(10);

    public LeaseRenewalManager() {
    }

    public LeaseRenewalManager(Lease lease, long l, LeaseListener leaseListener) {
        this.renewUntil(lease, l, leaseListener);
    }

    static /* synthetic */ QueuerTask access$6(LeaseRenewalManager leaseRenewalManager) {
        return leaseRenewalManager.queuer;
    }

    private synchronized void addLease(Lease lease, long l, long l2, LeaseListener leaseListener, long l3) {
        Entry entry = this.findEntryDo(lease);
        if (entry != null && !this.removeLeaseInRenew(entry)) {
            this.leases.remove(entry);
        }
        this.insertEntry(new Entry(lease, l, l2, leaseListener), l3);
        this.calcActualRenews(l3);
    }

    private void calcActualRenews() {
        this.calcActualRenews(System.currentTimeMillis());
    }

    private void calcActualRenews(long l) {
        Iterator iterator = this.leases.values().iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            entry.actualRenew = entry.renew;
            if (entry.renewalsDone()) {
                if (l < entry.expiration || entry.desiredExpirationListener() != null) continue;
                iterator.remove();
                continue;
            }
            if (entry.endTime <= l && entry.listener == null) {
                iterator.remove();
                continue;
            }
            if (this.canBatch(entry)) continue;
            Iterator iterator2 = this.calcList.iterator();
            while (iterator2.hasNext()) {
                if (entry.renew >= ((Entry)iterator2.next()).actualRenew - 10000L) break;
                iterator2.remove();
            }
            if (this.calcList.size() == 10) {
                Entry entry2 = (Entry)this.calcList.remove(0);
                entry.actualRenew = entry2.actualRenew - 10000L;
            }
            this.calcList.add(entry);
        }
        this.calcList.clear();
        long l2 = this.wakeupTime();
        if (this.queuer == null) {
            if (l2 < Long.MAX_VALUE) {
                this.queuer = new QueuerTask(l2);
                this.tasker.add(this.queuer);
            }
        } else if (l2 < this.queuer.wakeup || l2 == Long.MAX_VALUE && this.leaseInRenew.isEmpty()) {
            this.notifyAll();
        }
    }

    private boolean canBatch(Entry entry) {
        Iterator iterator = this.leases.tailMap(entry).values().iterator();
        iterator.next();
        while (iterator.hasNext()) {
            Entry entry2 = (Entry)iterator.next();
            if (entry.renew - entry2.renew > 300000L) break;
            if (!entry.canBatch(entry2)) continue;
            return true;
        }
        return false;
    }

    public void cancel(Lease lease) throws UnknownLeaseException, RemoteException {
        this.remove(lease);
        lease.cancel();
    }

    public synchronized void clear() {
        this.leases.clear();
        this.leaseInRenew.clear();
        this.calcActualRenews();
    }

    private static LeaseMap createBatchLeaseMap(List list, long l) {
        Iterator iterator = list.iterator();
        Entry entry = (Entry)iterator.next();
        LeaseMap leaseMap = entry.lease.createLeaseMap(entry.getRenewDuration(l));
        while (iterator.hasNext()) {
            entry = (Entry)iterator.next();
            leaseMap.put(entry.lease, new Long(entry.getRenewDuration(l)));
        }
        return leaseMap;
    }

    private Entry findEntry(Lease lease) throws UnknownLeaseException {
        Entry entry = this.findEntryDo(lease);
        if (entry != null && (entry.renew < entry.endTime || System.currentTimeMillis() < entry.endTime)) {
            return entry;
        }
        throw new UnknownLeaseException();
    }

    private Entry findEntryDo(Lease lease) {
        Entry entry = LeaseRenewalManager.findLeaseFromIterator(this.leases.values().iterator(), lease);
        if (entry == null) {
            entry = LeaseRenewalManager.findLeaseFromIterator(this.leaseInRenew.iterator(), lease);
        }
        return entry;
    }

    private static Entry findLeaseFromIterator(Iterator iterator, Lease lease) {
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            if (!entry.lease.equals(lease)) continue;
            return entry;
        }
        return null;
    }

    public synchronized long getExpiration(Lease lease) throws UnknownLeaseException {
        return this.findEntry((Lease)lease).expiration;
    }

    private void insertEntry(Entry entry, long l) {
        entry.calcRenew(l);
        this.leases.put(entry, entry);
    }

    public synchronized void remove(Lease lease) throws UnknownLeaseException {
        Entry entry = this.findEntry(lease);
        if (!this.removeLeaseInRenew(entry)) {
            this.leases.remove(entry);
        }
        this.calcActualRenews();
    }

    private boolean removeLeaseInRenew(Entry entry) {
        int n = this.leaseInRenew.indexOf(entry);
        if (n < 0) {
            return false;
        }
        this.leaseInRenew.remove(n);
        return true;
    }

    private void renewAll(List list, long l) {
        Object object;
        Map map = null;
        Throwable throwable = null;
        ArrayList<Entry> arrayList = null;
        try {
            if (list.size() == 1) {
                object = (Entry)list.get(0);
                ((Entry)object).lease.renew(((Entry)object).getRenewDuration(l));
            } else {
                object = LeaseRenewalManager.createBatchLeaseMap(list, l);
                object.renewAll();
            }
        }
        catch (LeaseMapException leaseMapException) {
            map = leaseMapException.exceptionMap;
            arrayList = new ArrayList(map.size());
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            arrayList = new ArrayList<Entry>(list.size());
        }
        l = System.currentTimeMillis();
        object = this;
        synchronized (object) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Entry entry = (Entry)iterator.next();
                if (!this.removeLeaseInRenew(entry)) continue;
                if (arrayList == null) {
                    entry.ex = null;
                } else {
                    Throwable throwable3 = entry.ex = throwable != null ? throwable : (Throwable)map.get(entry.lease);
                }
                if (entry.ex == null) {
                    this.insertEntry(entry, l);
                    continue;
                }
                int n = ThrowableConstants.retryable(entry.ex);
                if (n == 0) {
                    entry.delayRenew();
                    this.leases.put(entry, entry);
                    continue;
                }
                if (entry.listener == null) continue;
                arrayList.add(entry);
            }
            this.calcActualRenews(l);
        }
        if (arrayList != null) {
            this.tell(arrayList);
        }
    }

    public void renewFor(Lease lease, long l, long l2, LeaseListener leaseListener) {
        this.validateDuration(l2, l == Long.MAX_VALUE, "desiredDuration");
        long l3 = System.currentTimeMillis();
        long l4 = l < Long.MAX_VALUE - l3 ? l3 + l : Long.MAX_VALUE;
        this.addLease(lease, l4, l2, leaseListener, l3);
    }

    public void renewFor(Lease lease, long l, LeaseListener leaseListener) {
        this.renewFor(lease, l, Long.MAX_VALUE, leaseListener);
    }

    public void renewUntil(Lease lease, long l, long l2, LeaseListener leaseListener) {
        this.validateDuration(l2, l == Long.MAX_VALUE, "desiredExpiration");
        this.addLease(lease, l, l2, leaseListener, System.currentTimeMillis());
    }

    public void renewUntil(Lease lease, long l, LeaseListener leaseListener) {
        if (l == -1L) {
            this.renewUntil(lease, Long.MAX_VALUE, -1L, leaseListener);
        } else {
            this.renewUntil(lease, l, Long.MAX_VALUE, leaseListener);
        }
    }

    public synchronized void setExpiration(Lease lease, long l) throws UnknownLeaseException {
        Entry entry = this.findEntry(lease);
        entry.expiration = l;
        if (l != Long.MAX_VALUE && entry.renewDuration == -1L) {
            entry.renewDuration = Long.MAX_VALUE;
        }
        if (this.leaseInRenew.indexOf(entry) < 0) {
            this.leases.remove(entry);
            long l2 = System.currentTimeMillis();
            this.insertEntry(entry, l2);
            this.calcActualRenews(l2);
        }
    }

    private void tell(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            if (entry.renewalsDone()) {
                DesiredExpirationListener desiredExpirationListener = entry.desiredExpirationListener();
                if (desiredExpirationListener == null) continue;
                desiredExpirationListener.expirationReached(new LeaseRenewalEvent(this, entry.lease, entry.expiration, null));
                continue;
            }
            entry.listener.notify(new LeaseRenewalEvent(this, entry.lease, entry.expiration, entry.ex));
        }
    }

    private void validateDuration(long l, boolean bl, String string) {
        if (!(l > 0L || l == -1L && bl)) {
            if (l == -1L) {
                throw new IllegalArgumentException("A renewDuration of Lease.ANY can only be used with a " + string + " of " + "Lease.FOREVER");
            }
            if (bl) {
                throw new IllegalArgumentException("When " + string + " is " + "Lease.FOREVER the only valid values for renewDuration " + "are a positive number, Lease.ANY, or Lease.FOREVER");
            }
            throw new IllegalArgumentException("When the " + string + " is not Lease.FOREVER the only valid values for " + "renewDuration are a positive number or Lease.FOREVER");
        }
    }

    private long wakeupTime() {
        if (this.leases.isEmpty()) {
            return Long.MAX_VALUE;
        }
        return ((Entry)this.leases.lastKey()).actualRenew;
    }

    private final class RenewTask
    implements TaskManager.Task {
        private final List bList = new ArrayList(1);
        private final boolean noRenewals;

        RenewTask(long l) {
            Entry entry = (Entry)LeaseRenewalManager.this.leases.lastKey();
            if (entry.renewalsDone() || entry.endTime <= l) {
                this.noRenewals = true;
                SortedMap sortedMap = LeaseRenewalManager.this.leases.tailMap(new Entry(l));
                Iterator iterator = sortedMap.values().iterator();
                while (iterator.hasNext()) {
                    Entry entry2 = (Entry)iterator.next();
                    if (!entry2.renewalsDone() && entry2.endTime > l) continue;
                    iterator.remove();
                    if (entry2.listener == null) continue;
                    this.bList.add(entry2);
                }
            } else {
                this.noRenewals = false;
                SortedMap sortedMap = LeaseRenewalManager.this.leases.tailMap(new Entry(entry.renew + 300000L));
                Iterator iterator = sortedMap.values().iterator();
                while (iterator.hasNext()) {
                    Entry entry3 = (Entry)iterator.next();
                    if (entry3 != entry && !entry3.canBatch(entry)) continue;
                    iterator.remove();
                    LeaseRenewalManager.this.leaseInRenew.add(entry3);
                    this.bList.add(entry3);
                }
            }
        }

        private List processBadLeases(long l) {
            ArrayList<Entry> arrayList = null;
            LeaseRenewalManager leaseRenewalManager = LeaseRenewalManager.this;
            synchronized (leaseRenewalManager) {
                Iterator iterator = this.bList.iterator();
                while (iterator.hasNext()) {
                    Entry entry = (Entry)iterator.next();
                    if (entry.endTime > l) continue;
                    iterator.remove();
                    if (!LeaseRenewalManager.this.removeLeaseInRenew(entry) || entry.listener == null) continue;
                    if (arrayList == null) {
                        arrayList = new ArrayList<Entry>(1);
                    }
                    arrayList.add(entry);
                }
            }
            return arrayList;
        }

        public void run() {
            if (this.noRenewals) {
                LeaseRenewalManager.this.tell(this.bList);
            } else {
                long l = System.currentTimeMillis();
                List list = this.processBadLeases(l);
                if (!this.bList.isEmpty()) {
                    LeaseRenewalManager.this.renewAll(this.bList, l);
                }
                if (list != null) {
                    LeaseRenewalManager.this.tell(list);
                }
            }
        }

        public boolean runAfter(List list, int n) {
            return false;
        }
    }

    private static class Entry
    implements Comparable {
        private static long cnt = 0L;
        public final long id;
        public final Lease lease;
        public long expiration;
        public long renewDuration;
        public final LeaseListener listener;
        public long endTime;
        public long renew;
        public long actualRenew;
        public Throwable ex = null;

        public Entry(long l) {
            this.renew = l;
            this.id = Long.MAX_VALUE;
            this.lease = null;
            this.listener = null;
        }

        public Entry(Lease lease, long l, long l2, LeaseListener leaseListener) {
            this.endTime = lease.getExpiration();
            this.lease = lease;
            this.expiration = l;
            this.renewDuration = l2;
            this.listener = leaseListener;
            this.id = cnt++;
        }

        public void calcRenew(long l) {
            this.endTime = this.lease.getExpiration();
            if (this.renewalsDone()) {
                this.renew = this.desiredExpirationListener() == null ? Long.MAX_VALUE : this.expiration;
                return;
            }
            long l2 = this.endTime - l;
            l2 = l2 <= 20000L ? 10000L : (l2 <= 80000L ? (l2 /= 2L) : (l2 <= 604800000L ? (l2 /= 8L) : (l2 <= 1209600000L ? 86400000L : 259200000L)));
            this.renew = this.endTime - l2;
        }

        public boolean canBatch(Entry entry) {
            return !(this.renewalsDone() || entry.renewalsDone() || !this.lease.canBatch(entry.lease) || this.renewDuration != -1L && this.renew - entry.renew > 5000L && this.endTime - entry.renew > this.renewDuration / 2L || entry.renewDuration != -1L && entry.renew <= this.renew - entry.renewDuration && entry.renew < entry.expiration - entry.renewDuration);
        }

        public int compareTo(Object object) {
            if (this == object) {
                return 0;
            }
            Entry entry = (Entry)object;
            if (this.renew < entry.renew || this.renew == entry.renew && this.id < entry.id) {
                return 1;
            }
            return -1;
        }

        public void delayRenew() {
            long l = this.endTime - this.renew;
            if (l <= 10000L) {
                return;
            }
            l = l <= 30000L ? 10000L : (l <= 3600000L ? (l /= 3L) : (l <= 86400000L ? 1800000L : (l <= 604800000L ? 10800000L : 28800000L)));
            this.renew += l;
        }

        public DesiredExpirationListener desiredExpirationListener() {
            if (this.listener == null) {
                return null;
            }
            if (this.listener instanceof DesiredExpirationListener) {
                return (DesiredExpirationListener)this.listener;
            }
            return null;
        }

        public long getRenewDuration(long l) {
            if (this.renewDuration == -1L) {
                return this.renewDuration;
            }
            return Math.min(this.expiration - l, this.renewDuration);
        }

        public boolean renewalsDone() {
            return this.expiration <= this.endTime;
        }
    }

    private class QueuerTask
    implements TaskManager.Task {
        long wakeup;

        QueuerTask(long l) {
            this.wakeup = l;
        }

        public void run() {
            LeaseRenewalManager leaseRenewalManager = LeaseRenewalManager.this;
            synchronized (leaseRenewalManager) {
                try {
                    while (true) {
                        this.wakeup = LeaseRenewalManager.this.wakeupTime();
                        if (this.wakeup != Long.MAX_VALUE || !LeaseRenewalManager.this.leaseInRenew.isEmpty()) {
                            long l = System.currentTimeMillis();
                            long l2 = this.wakeup - l;
                            if (l2 <= 0L) {
                                LeaseRenewalManager.this.tasker.add(new RenewTask(l));
                                continue;
                            }
                            LeaseRenewalManager.this.wait(l2);
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {}
                LeaseRenewalManager.this.queuer = null;
            }
        }

        public boolean runAfter(List list, int n) {
            return false;
        }
    }
}

