/*
 * Decompiled with CFR 0.152.
 */
package net.jini.lookup;

import com.sun.jini.lookup.entry.LookupAttributes;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.server.RemoteObject;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import net.jini.core.entry.Entry;
import net.jini.core.lease.Lease;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.lookup.ServiceRegistration;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.lease.LeaseListener;
import net.jini.lease.LeaseRenewalEvent;
import net.jini.lease.LeaseRenewalManager;
import net.jini.lookup.ServiceIDListener;

public class JoinManager {
    private ServiceIDListener callback;
    private Entry[] lookupAttr = null;
    private ServiceItem serviceItem;
    private final ArrayList joinSet = new ArrayList();
    private final ArrayList listeners = new ArrayList();
    private final ArrayList task = new ArrayList();
    private TaskThread taskThread = null;
    private LeaseRenewalManager leaseRenewalMgr = null;
    private DiscoveryManagement discMgr = null;
    private DiscMgrListener discMgrListener = new DiscMgrListener();
    private boolean bTerminated = false;
    private boolean bCreateDiscMgr = false;

    public JoinManager(Object object, Entry[] entryArray, ServiceID serviceID, DiscoveryManagement discoveryManagement, LeaseRenewalManager leaseRenewalManager) throws IOException {
        this.discMgr = discoveryManagement;
        this.createJoinManager(serviceID, object, entryArray, this.callback, leaseRenewalManager);
    }

    public JoinManager(Object object, Entry[] entryArray, ServiceIDListener serviceIDListener, DiscoveryManagement discoveryManagement, LeaseRenewalManager leaseRenewalManager) throws IOException {
        this.discMgr = discoveryManagement;
        this.createJoinManager(null, object, entryArray, serviceIDListener, leaseRenewalManager);
    }

    static /* synthetic */ TaskThread access$9(JoinManager joinManager) {
        return joinManager.taskThread;
    }

    public void addAttributes(Entry[] entryArray) {
        this.addAttributes(entryArray, false);
    }

    public void addAttributes(Entry[] entryArray, boolean bl) {
        addAttributesTask addAttributesTask2;
        ServiceItem serviceItem = this.serviceItem;
        synchronized (serviceItem) {
            this.lookupAttr = LookupAttributes.add(this.lookupAttr, entryArray, bl);
            addAttributesTask2 = new addAttributesTask(entryArray, this.lookupAttr);
        }
        this.createTaskThread(addAttributesTask2);
    }

    private void addJoinSet(ProxyReg proxyReg) {
        if (proxyReg.proxy == null || proxyReg.srvcRegistration == null) {
            throw new IllegalArgumentException("bad proxy or ServiceRegistration");
        }
        ArrayList arrayList = this.joinSet;
        synchronized (arrayList) {
            if (!this.joinSet.contains(proxyReg)) {
                this.joinSet.add(proxyReg);
            }
        }
        ArrayList arrayList2 = this.listeners;
        synchronized (arrayList2) {
            if (this.listeners.isEmpty()) {
                Object var4_4 = null;
                return;
            }
            arrayList = (ArrayList)this.listeners.clone();
        }
        this.discoveredNotifyListener(proxyReg.proxy, arrayList);
    }

    private ServiceRegistrar[] buildServiceRegistrar(ArrayList arrayList) {
        int n = 0;
        ServiceRegistrar[] serviceRegistrarArray = new ServiceRegistrar[arrayList.size()];
        Iterator iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            ProxyReg proxyReg = (ProxyReg)iterator.next();
            serviceRegistrarArray[n++] = proxyReg.proxy;
        }
        return serviceRegistrarArray;
    }

    private void createJoinManager(ServiceID serviceID, Object object, Entry[] entryArray, ServiceIDListener serviceIDListener, LeaseRenewalManager leaseRenewalManager) throws IOException {
        if (!(object instanceof Serializable)) {
            if (object instanceof Remote) {
                try {
                    RemoteObject.toStub((Remote)object);
                }
                catch (NoSuchObjectException noSuchObjectException) {
                    throw new IllegalArgumentException("obj must be Serializable or a RemoteStub or an exported RemoteObject");
                }
            } else {
                throw new IllegalArgumentException("obj must be Serializable or a RemoteStub or an exported RemoteObject");
            }
        }
        this.lookupAttr = entryArray == null ? new Entry[0] : (Entry[])entryArray.clone();
        this.serviceItem = new ServiceItem(serviceID, object, this.lookupAttr);
        this.leaseRenewalMgr = leaseRenewalManager != null ? leaseRenewalManager : new LeaseRenewalManager();
        this.callback = serviceIDListener;
        if (this.discMgr == null) {
            this.bCreateDiscMgr = true;
            this.discMgr = new LookupDiscoveryManager(new String[]{""}, null, null);
        }
        this.discMgr.addDiscoveryListener(this.discMgrListener);
    }

    private void createTaskThread(Task task) {
        ArrayList arrayList = this.task;
        synchronized (arrayList) {
            if (this.bTerminated) {
                Object var3_3 = null;
                return;
            }
            this.task.add(task);
            if (this.taskThread == null) {
                this.taskThread = new TaskThread();
                this.taskThread.start();
            }
        }
    }

    private void discardedNotifyListener(ServiceRegistrar serviceRegistrar, ArrayList arrayList) {
        this.notifyListener(serviceRegistrar, arrayList, false);
    }

    private void discoveredNotifyListener(ServiceRegistrar serviceRegistrar, ArrayList arrayList) {
        this.notifyListener(serviceRegistrar, arrayList, true);
    }

    private void discoveredNotifyListener(DiscoveryListener discoveryListener, ArrayList arrayList) {
        DiscoveryEvent discoveryEvent = new DiscoveryEvent((Object)this, this.buildServiceRegistrar(arrayList));
        discoveryListener.discovered(discoveryEvent);
    }

    ProxyReg findReg(ServiceRegistrar serviceRegistrar) {
        Iterator iterator = ((AbstractList)this.joinSet).iterator();
        while (iterator.hasNext()) {
            ProxyReg proxyReg = (ProxyReg)iterator.next();
            if (!proxyReg.proxy.equals(serviceRegistrar)) continue;
            return proxyReg;
        }
        return null;
    }

    public Entry[] getAttributes() {
        ServiceItem serviceItem = this.serviceItem;
        synchronized (serviceItem) {
            Entry[] entryArray = (Entry[])this.lookupAttr.clone();
            Object var3_3 = null;
            return entryArray;
        }
    }

    public DiscoveryManagement getDiscoveryManager() {
        return this.discMgr;
    }

    public ServiceRegistrar[] getJoinSet() {
        ArrayList arrayList = this.joinSet;
        synchronized (arrayList) {
            ServiceRegistrar[] serviceRegistrarArray = new ServiceRegistrar[this.joinSet.size()];
            int n = 0;
            Iterator iterator = ((AbstractList)this.joinSet).iterator();
            while (iterator.hasNext()) {
                serviceRegistrarArray[n++] = ((ProxyReg)iterator.next()).proxy;
            }
            ServiceRegistrar[] serviceRegistrarArray2 = serviceRegistrarArray;
            Object var3_6 = null;
            return serviceRegistrarArray2;
        }
    }

    public LeaseRenewalManager getLeaseRenewalManager() {
        return this.leaseRenewalMgr;
    }

    public void modifyAttributes(Entry[] entryArray, Entry[] entryArray2) {
        this.modifyAttributes(entryArray, entryArray2, false);
    }

    public void modifyAttributes(Entry[] entryArray, Entry[] entryArray2, boolean bl) {
        modifyAttributesTask modifyAttributesTask2;
        ServiceItem serviceItem = this.serviceItem;
        synchronized (serviceItem) {
            this.lookupAttr = LookupAttributes.modify(this.lookupAttr, entryArray, entryArray2, bl);
            modifyAttributesTask2 = new modifyAttributesTask(entryArray, entryArray2, this.lookupAttr);
        }
        this.createTaskThread(modifyAttributesTask2);
    }

    private void notifyListener(ServiceRegistrar serviceRegistrar, ArrayList arrayList, boolean bl) {
        ServiceRegistrar[] serviceRegistrarArray = new ServiceRegistrar[]{serviceRegistrar};
        DiscoveryEvent discoveryEvent = new DiscoveryEvent((Object)this, serviceRegistrarArray);
        Iterator iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            if (bl) {
                ((DiscoveryListener)iterator.next()).discovered(discoveryEvent);
                continue;
            }
            ((DiscoveryListener)iterator.next()).discarded(discoveryEvent);
        }
    }

    private void removeJoinSet(ProxyReg proxyReg) {
        if (proxyReg.proxy == null || proxyReg.srvcRegistration == null) {
            throw new IllegalArgumentException("bad proxy or ServiceRegistration");
        }
        ArrayList arrayList = this.joinSet;
        synchronized (arrayList) {
            ((AbstractCollection)this.joinSet).remove(proxyReg);
            try {
                this.leaseRenewalMgr.cancel(proxyReg.srvcRegistration.getLease());
            }
            catch (Exception exception) {}
        }
        ArrayList arrayList2 = this.listeners;
        synchronized (arrayList2) {
            if (this.listeners.isEmpty()) {
                Object var4_4 = null;
                return;
            }
            arrayList = (ArrayList)this.listeners.clone();
        }
        this.discardedNotifyListener(proxyReg.proxy, arrayList);
    }

    public void setAttributes(Entry[] entryArray) {
        setAttributesTask setAttributesTask2;
        ServiceItem serviceItem = this.serviceItem;
        synchronized (serviceItem) {
            this.lookupAttr = (Entry[])entryArray.clone();
            setAttributesTask2 = new setAttributesTask(this.lookupAttr);
        }
        this.createTaskThread(setAttributesTask2);
    }

    public void terminate() {
        TaskThread taskThread;
        this.discMgr.removeDiscoveryListener(this.discMgrListener);
        if (this.bCreateDiscMgr) {
            this.discMgr.terminate();
        }
        ArrayList arrayList = this.task;
        synchronized (arrayList) {
            this.bTerminated = true;
            taskThread = this.taskThread;
        }
        if (taskThread != null) {
            taskThread.interrupt();
            try {
                taskThread.join();
            }
            catch (Exception exception) {}
        }
        arrayList = this.joinSet;
        synchronized (arrayList) {
            Iterator iterator = ((AbstractList)this.joinSet).iterator();
            while (iterator.hasNext()) {
                try {
                    this.leaseRenewalMgr.cancel(((ProxyReg)iterator.next()).srvcRegistration.getLease());
                }
                catch (Exception exception) {}
            }
            this.joinSet.clear();
        }
    }

    private class DiscMgrListener
    implements DiscoveryListener {
        DiscMgrListener() {
        }

        public void discarded(DiscoveryEvent discoveryEvent) {
            ServiceRegistrar[] serviceRegistrarArray = discoveryEvent.getRegistrars();
            DiscardProxyTask discardProxyTask = new DiscardProxyTask(serviceRegistrarArray);
            JoinManager.this.createTaskThread(discardProxyTask);
        }

        public void discovered(DiscoveryEvent discoveryEvent) {
            ServiceRegistrar[] serviceRegistrarArray = discoveryEvent.getRegistrars();
            RegisterTask registerTask = new RegisterTask(serviceRegistrarArray);
            JoinManager.this.createTaskThread(registerTask);
        }
    }

    private static interface Task {
        public void exec();
    }

    private class ProxyReg {
        public ServiceRegistrar proxy;
        public ServiceRegistration srvcRegistration = null;
        private DiscLeaseListener dListener = new DiscLeaseListener();

        public ProxyReg(ServiceRegistrar serviceRegistrar) {
            if (serviceRegistrar == null) {
                throw new IllegalArgumentException("proxy can't be null");
            }
            this.proxy = serviceRegistrar;
        }

        public void addAttributes(Entry[] entryArray) {
            try {
                this.srvcRegistration.addAttributes(entryArray);
            }
            catch (Exception exception) {
                this.fail(exception);
            }
        }

        public boolean equals(Object object) {
            if (object instanceof ProxyReg) {
                return this.proxy.equals(((ProxyReg)object).proxy);
            }
            return false;
        }

        public void fail(Throwable throwable) {
            try {
                if (System.getProperty("com.sun.jini.join.debug") != null) {
                    throwable.printStackTrace();
                }
            }
            catch (SecurityException securityException) {}
            JoinManager.this.discMgr.discard(this.proxy);
        }

        public int hashCode() {
            return this.proxy.hashCode();
        }

        public void modifyAttributes(Entry[] entryArray, Entry[] entryArray2) {
            try {
                this.srvcRegistration.modifyAttributes(entryArray, entryArray2);
            }
            catch (Exception exception) {
                this.fail(exception);
            }
        }

        public void register() {
            try {
                if (this.proxy == null) {
                    throw new RuntimeException("proxy is null");
                }
                this.srvcRegistration = this.proxy.register(JoinManager.this.serviceItem, Long.MAX_VALUE);
                Lease lease = this.srvcRegistration.getLease();
                JoinManager.this.leaseRenewalMgr.renewUntil(this.srvcRegistration.getLease(), Long.MAX_VALUE, this.dListener);
                JoinManager.this.addJoinSet(this);
                if (((JoinManager)JoinManager.this).serviceItem.serviceID == null) {
                    ((JoinManager)JoinManager.this).serviceItem.serviceID = this.srvcRegistration.getServiceID();
                    if (JoinManager.this.callback != null) {
                        JoinManager.this.callback.serviceIDNotify(((JoinManager)JoinManager.this).serviceItem.serviceID);
                    }
                }
            }
            catch (Exception exception) {
                this.fail(exception);
            }
        }

        public void setAttributes(Entry[] entryArray) {
            try {
                this.srvcRegistration.setAttributes(entryArray);
            }
            catch (Exception exception) {
                this.fail(exception);
            }
        }

        private class DiscLeaseListener
        implements LeaseListener {
            DiscLeaseListener() {
            }

            public void notify(LeaseRenewalEvent leaseRenewalEvent) {
                if (leaseRenewalEvent.getException() instanceof UnknownLeaseException) {
                    JoinManager joinManager = JoinManager.this;
                    joinManager.getClass();
                    LeaseExpireNotifyTask leaseExpireNotifyTask = joinManager.new LeaseExpireNotifyTask(ProxyReg.this);
                    JoinManager.this.createTaskThread(leaseExpireNotifyTask);
                } else {
                    ProxyReg.this.fail(leaseRenewalEvent.getException());
                }
            }
        }
    }

    private class addAttributesTask
    implements Task {
        protected Entry[] attrSets;
        protected Entry[] finalAttrSet;

        addAttributesTask(Entry[] entryArray, Entry[] entryArray2) {
            this.attrSets = (Entry[])entryArray.clone();
            this.finalAttrSet = entryArray2;
        }

        protected void doAttributes(ProxyReg proxyReg) {
            proxyReg.addAttributes(this.attrSets);
        }

        public void exec() {
            Iterator iterator = ((AbstractList)JoinManager.this.joinSet).iterator();
            while (iterator.hasNext()) {
                ProxyReg proxyReg = (ProxyReg)iterator.next();
                this.doAttributes(proxyReg);
            }
            ((JoinManager)JoinManager.this).serviceItem.attributeSets = this.finalAttrSet;
        }
    }

    private final class setAttributesTask
    extends addAttributesTask {
        setAttributesTask(Entry[] entryArray) {
            super(entryArray, entryArray);
        }

        protected void doAttributes(ProxyReg proxyReg) {
            proxyReg.setAttributes(this.attrSets);
        }
    }

    private final class modifyAttributesTask
    extends addAttributesTask {
        private Entry[] attrSetTemplate;

        modifyAttributesTask(Entry[] entryArray, Entry[] entryArray2, Entry[] entryArray3) {
            super(entryArray2, entryArray3);
            this.attrSetTemplate = (Entry[])entryArray.clone();
        }

        protected void doAttributes(ProxyReg proxyReg) {
            proxyReg.modifyAttributes(this.attrSetTemplate, this.attrSets);
        }
    }

    private class RegisterTask
    implements Task {
        private ServiceRegistrar[] proxys;

        RegisterTask(ServiceRegistrar[] serviceRegistrarArray) {
            this.proxys = serviceRegistrarArray;
        }

        public void exec() {
            int n = 0;
            while (n < this.proxys.length) {
                if (!this.proxys[n].equals(((JoinManager)JoinManager.this).serviceItem.service)) {
                    ProxyReg proxyReg = new ProxyReg(this.proxys[n]);
                    if (!JoinManager.this.joinSet.contains(proxyReg)) {
                        proxyReg.register();
                    }
                }
                ++n;
            }
        }
    }

    private class LeaseExpireNotifyTask
    implements Task {
        protected ProxyReg reg;

        LeaseExpireNotifyTask(ProxyReg proxyReg) {
            this.reg = proxyReg;
        }

        public void exec() {
            if (JoinManager.this.joinSet.contains(this.reg)) {
                this.reg.register();
            }
        }
    }

    private class DiscardProxyTask
    implements Task {
        private ServiceRegistrar[] proxys;

        public DiscardProxyTask(ServiceRegistrar[] serviceRegistrarArray) {
            this.proxys = serviceRegistrarArray;
        }

        public void exec() {
            int n = 0;
            while (n < this.proxys.length) {
                ProxyReg proxyReg = JoinManager.this.findReg(this.proxys[n]);
                if (proxyReg != null) {
                    JoinManager.this.removeJoinSet(proxyReg);
                }
                ++n;
            }
        }
    }

    private class TaskThread
    extends Thread {
        public TaskThread() {
            super("taskThread");
            this.setDaemon(true);
        }

        public void run() {
            while (!this.isInterrupted()) {
                Task task;
                ArrayList arrayList = JoinManager.this.task;
                synchronized (arrayList) {
                    if (JoinManager.this.task.isEmpty()) {
                        JoinManager.this.taskThread = null;
                        Object var3_3 = null;
                        return;
                    }
                    task = (Task)JoinManager.this.task.remove(0);
                }
                task.exec();
            }
        }
    }
}

